/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.ImmutableMap;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.List;
import java.util.Map;

public class TodoCommentCheck
extends AbstractFormatCheck {
    public TodoCommentCheck() {
        super("TODO:");
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        FileContents contents = this.getFileContents();
        this.checkCppComments(contents);
        this.checkBadComments(contents);
    }

    private void checkCppComments(FileContents aContents) {
        ImmutableMap<Integer, TextBlock> comments = aContents.getCppComments();
        for (Map.Entry entry : comments.entrySet()) {
            String cmt = ((TextBlock)entry.getValue()).getText()[0];
            if (!this.getRegexp().matcher(cmt).find()) continue;
            this.log((int)((Integer)entry.getKey()), "todo.match", this.getFormat());
        }
    }

    private void checkBadComments(FileContents aContents) {
        ImmutableMap<Integer, List<TextBlock>> allComments = aContents.getCComments();
        for (Map.Entry entry : allComments.entrySet()) {
            for (TextBlock line : (List)entry.getValue()) {
                String[] cmt = line.getText();
                for (int i = 0; i < cmt.length; ++i) {
                    if (!this.getRegexp().matcher(cmt[i]).find()) continue;
                    this.log((Integer)entry.getKey() + i, "todo.match", this.getFormat());
                }
            }
        }
    }
}

