/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.File;

public class OuterTypeFilenameCheck
extends Check {
    private boolean mSeenFirstToken;
    private String mFileName;
    private boolean mHasPublic;
    private boolean mValidFirst;
    private DetailAST mWrongType;

    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 157};
    }

    public void beginTree(DetailAST aAST) {
        this.mFileName = this.getFileName();
        this.mSeenFirstToken = false;
        this.mValidFirst = false;
        this.mHasPublic = false;
        this.mWrongType = null;
    }

    public void visitToken(DetailAST aAST) {
        String outerTypeName = aAST.findFirstToken(58).getText();
        if (!this.mSeenFirstToken) {
            if (this.mFileName.equals(outerTypeName)) {
                this.mValidFirst = true;
            } else {
                this.mWrongType = aAST;
            }
        } else {
            DetailAST modifiers = aAST.findFirstToken(5);
            if (modifiers.findFirstToken(62) != null && aAST.getParent() == null) {
                this.mHasPublic = true;
            }
        }
        this.mSeenFirstToken = true;
    }

    public void finishTree(DetailAST aRootAST) {
        if (!this.mValidFirst && !this.mHasPublic && this.mWrongType != null) {
            this.log(this.mWrongType.getLineNo(), "type.file.mismatch", new Object[0]);
        }
    }

    private String getFileName() {
        String fname = this.getFileContents().getFilename();
        fname = fname.substring(fname.lastIndexOf(File.separatorChar) + 1);
        fname = fname.replaceAll("\\.[^\\.]*$", "");
        return fname;
    }
}

