/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractTypeAwareCheck;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocMethodCheck
extends AbstractTypeAwareCheck {
    private static final Pattern MATCH_JAVADOC_ARG = Utils.createPattern("@(throws|exception|param)\\s+(\\S+)\\s+\\S*");
    private static final Pattern MATCH_JAVADOC_ARG_MULTILINE_START = Utils.createPattern("@(throws|exception|param)\\s+(\\S+)\\s*$");
    private static final Pattern MATCH_JAVADOC_MULTILINE_CONT = Utils.createPattern("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final Pattern MATCH_JAVADOC_NOARG = Utils.createPattern("@(return|see)\\s+\\S");
    private static final Pattern MATCH_JAVADOC_NOARG_MULTILINE_START = Utils.createPattern("@(return|see)\\s*$");
    private static final Pattern MATCH_JAVADOC_NOARG_CURLY = Utils.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    private static final int MAX_CHILDREN = 7;
    private static final int BODY_SIZE = 3;
    private Scope mScope = Scope.PRIVATE;
    private Scope mExcludeScope;
    private boolean mAllowUndeclaredRTE;
    private boolean mAllowThrowsTagsForSubclasses;
    private boolean mAllowMissingParamTags;
    private boolean mAllowMissingThrowsTags;
    private boolean mAllowMissingReturnTag;
    private boolean mAllowMissingJavadoc;
    private boolean mAllowMissingPropertyJavadoc;

    public void setScope(String aFrom) {
        this.mScope = Scope.getInstance(aFrom);
    }

    public void setExcludeScope(String aScope) {
        this.mExcludeScope = Scope.getInstance(aScope);
    }

    public void setAllowUndeclaredRTE(boolean aFlag) {
        this.mAllowUndeclaredRTE = aFlag;
    }

    public void setAllowThrowsTagsForSubclasses(boolean aFlag) {
        this.mAllowThrowsTagsForSubclasses = aFlag;
    }

    public void setAllowMissingParamTags(boolean aFlag) {
        this.mAllowMissingParamTags = aFlag;
    }

    public void setAllowMissingThrowsTags(boolean aFlag) {
        this.mAllowMissingThrowsTags = aFlag;
    }

    public void setAllowMissingReturnTag(boolean aFlag) {
        this.mAllowMissingReturnTag = aFlag;
    }

    public void setAllowMissingJavadoc(boolean aFlag) {
        this.mAllowMissingJavadoc = aFlag;
    }

    public void setAllowMissingPropertyJavadoc(boolean aFlag) {
        this.mAllowMissingPropertyJavadoc = aFlag;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{16, 30, 14, 154, 15, 9, 8, 161};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 161};
    }

    @Override
    protected final void processAST(DetailAST aAST) {
        Scope theScope = this.calculateScope(aAST);
        if (this.shouldCheck(aAST, theScope)) {
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(aAST.getLineNo());
            if (cmt == null) {
                if (!this.isMissingJavadocAllowed(aAST)) {
                    this.log(aAST, "javadoc.missing", new Object[0]);
                }
            } else {
                this.checkComment(aAST, cmt);
            }
        }
    }

    @Override
    protected final void logLoadError(AbstractTypeAwareCheck.Token aIdent) {
        this.logLoadErrorImpl(aIdent.getLineNo(), aIdent.getColumnNo(), "javadoc.classInfo", JavadocTagInfo.THROWS.getText(), aIdent.getText());
    }

    protected boolean isMissingJavadocAllowed(DetailAST aAST) {
        return this.mAllowMissingJavadoc || this.isOverrideMethod(aAST) || this.mAllowMissingPropertyJavadoc && (this.isSetterMethod(aAST) || this.isGetterMethod(aAST));
    }

    private boolean shouldCheck(DetailAST aAST, Scope aScope) {
        Scope surroundingScope = ScopeUtils.getSurroundingScope(aAST);
        return aScope.isIn(this.mScope) && surroundingScope.isIn(this.mScope) && (this.mExcludeScope == null || !aScope.isIn(this.mExcludeScope) || !surroundingScope.isIn(this.mExcludeScope));
    }

    private void checkComment(DetailAST aAST, TextBlock aComment) {
        List<JavadocTag> tags = this.getMethodTags(aComment);
        if (this.hasShortCircuitTag(aAST, tags)) {
            return;
        }
        Iterator<JavadocTag> it = tags.iterator();
        if (aAST.getType() != 161) {
            boolean hasInheritDocTag;
            for (hasInheritDocTag = false; it.hasNext() && !hasInheritDocTag; hasInheritDocTag |= it.next().isInheritDocTag()) {
            }
            this.checkParamTags(tags, aAST, !hasInheritDocTag);
            this.checkThrowsTags(tags, this.getThrows(aAST), !hasInheritDocTag);
            if (this.isFunction(aAST)) {
                this.checkReturnTag(tags, aAST.getLineNo(), !hasInheritDocTag);
            }
        }
        for (JavadocTag jt : tags) {
            if (jt.isSeeOrInheritDocTag()) continue;
            this.log(jt.getLineNo(), "javadoc.unusedTagGeneral", new Object[0]);
        }
    }

    private boolean hasShortCircuitTag(DetailAST aAST, List<JavadocTag> aTags) {
        if (aTags.size() != 1 || !aTags.get(0).isInheritDocTag()) {
            return false;
        }
        if (!JavadocTagInfo.INHERIT_DOC.isValidOn(aAST)) {
            this.log(aAST, "javadoc.invalidInheritDoc", new Object[0]);
        }
        return true;
    }

    private Scope calculateScope(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        return ScopeUtils.inInterfaceOrAnnotationBlock(aAST) ? Scope.PUBLIC : declaredScope;
    }

    private List<JavadocTag> getMethodTags(TextBlock aComment) {
        String[] lines = aComment.getText();
        ArrayList tags = Lists.newArrayList();
        int currentLine = aComment.getStartLineNo() - 1;
        for (int i = 0; i < lines.length; ++i) {
            ++currentLine;
            Matcher javadocArgMatcher = MATCH_JAVADOC_ARG.matcher(lines[i]);
            Matcher javadocNoargMatcher = MATCH_JAVADOC_NOARG.matcher(lines[i]);
            Matcher noargCurlyMatcher = MATCH_JAVADOC_NOARG_CURLY.matcher(lines[i]);
            Matcher argMultilineStart = MATCH_JAVADOC_ARG_MULTILINE_START.matcher(lines[i]);
            Matcher noargMultilineStart = MATCH_JAVADOC_NOARG_MULTILINE_START.matcher(lines[i]);
            if (javadocArgMatcher.find()) {
                int col = javadocArgMatcher.start(1) - 1;
                if (i == 0) {
                    col += aComment.getStartColNo();
                }
                tags.add(new JavadocTag(currentLine, col, javadocArgMatcher.group(1), javadocArgMatcher.group(2)));
                continue;
            }
            if (javadocNoargMatcher.find()) {
                int col = javadocNoargMatcher.start(1) - 1;
                if (i == 0) {
                    col += aComment.getStartColNo();
                }
                tags.add(new JavadocTag(currentLine, col, javadocNoargMatcher.group(1)));
                continue;
            }
            if (noargCurlyMatcher.find()) {
                int col = noargCurlyMatcher.start(1) - 1;
                if (i == 0) {
                    col += aComment.getStartColNo();
                }
                tags.add(new JavadocTag(currentLine, col, noargCurlyMatcher.group(1)));
                continue;
            }
            if (argMultilineStart.find()) {
                String p1 = argMultilineStart.group(1);
                String p2 = argMultilineStart.group(2);
                int col = argMultilineStart.start(1) - 1;
                if (i == 0) {
                    col += aComment.getStartColNo();
                }
                for (int remIndex = i + 1; remIndex < lines.length; ++remIndex) {
                    Matcher multilineCont = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[remIndex]);
                    if (!multilineCont.find()) continue;
                    remIndex = lines.length;
                    String lFin = multilineCont.group(1);
                    if (lFin.equals(NEXT_TAG) || lFin.equals(END_JAVADOC)) continue;
                    tags.add(new JavadocTag(currentLine, col, p1, p2));
                }
                continue;
            }
            if (!noargMultilineStart.find()) continue;
            String p1 = noargMultilineStart.group(1);
            int col = noargMultilineStart.start(1) - 1;
            if (i == 0) {
                col += aComment.getStartColNo();
            }
            for (int remIndex = i + 1; remIndex < lines.length; ++remIndex) {
                Matcher multilineCont = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[remIndex]);
                if (!multilineCont.find()) continue;
                remIndex = lines.length;
                String lFin = multilineCont.group(1);
                if (lFin.equals(NEXT_TAG) || lFin.equals(END_JAVADOC)) continue;
                tags.add(new JavadocTag(currentLine, col, p1));
            }
        }
        return tags;
    }

    private List<DetailAST> getParameters(DetailAST aAST) {
        DetailAST params = aAST.findFirstToken(20);
        ArrayList retVal = Lists.newArrayList();
        for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            DetailAST ident = child.findFirstToken(58);
            retVal.add(ident);
        }
        return retVal;
    }

    private List<ExceptionInfo> getThrows(DetailAST aAST) {
        ArrayList retVal = Lists.newArrayList();
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST != null) {
            for (DetailAST child = throwsAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 58 && child.getType() != 59) continue;
                FullIdent fi = FullIdent.createFullIdent(child);
                ExceptionInfo ei = new ExceptionInfo(new AbstractTypeAwareCheck.Token(fi), this.getCurrentClassName());
                retVal.add(ei);
            }
        }
        return retVal;
    }

    private void checkParamTags(List<JavadocTag> aTags, DetailAST aParent, boolean aReportExpectedTags) {
        List<DetailAST> params = this.getParameters(aParent);
        List<DetailAST> typeParams = CheckUtils.getTypeParameters(aParent);
        ListIterator<JavadocTag> tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            boolean found = false;
            Iterator<DetailAST> paramIt = params.iterator();
            while (paramIt.hasNext()) {
                DetailAST param = paramIt.next();
                if (!param.getText().equals(tag.getArg1())) continue;
                found = true;
                paramIt.remove();
                break;
            }
            if (tag.getArg1().startsWith("<") && tag.getArg1().endsWith(">")) {
                Iterator<DetailAST> typeParamsIt = typeParams.iterator();
                while (typeParamsIt.hasNext()) {
                    DetailAST typeParam = typeParamsIt.next();
                    if (!typeParam.findFirstToken(58).getText().equals(tag.getArg1().substring(1, tag.getArg1().length() - 1))) continue;
                    found = true;
                    typeParamsIt.remove();
                    break;
                }
            }
            if (found) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), "javadoc.unusedTag", "@param", tag.getArg1());
        }
        if (!this.mAllowMissingParamTags && aReportExpectedTags) {
            for (DetailAST param : params) {
                this.log(param, "javadoc.expectedTag", JavadocTagInfo.PARAM.getText(), param.getText());
            }
            for (DetailAST typeParam : typeParams) {
                this.log(typeParam, "javadoc.expectedTag", JavadocTagInfo.PARAM.getText(), "<" + typeParam.findFirstToken(58).getText() + ">");
            }
        }
    }

    private boolean isFunction(DetailAST aAST) {
        DetailAST typeAST;
        boolean retVal = false;
        if (aAST.getType() == 9 && (typeAST = aAST.findFirstToken(13)) != null && typeAST.findFirstToken(49) == null) {
            retVal = true;
        }
        return retVal;
    }

    private void checkReturnTag(List<JavadocTag> aTags, int aLineNo, boolean aReportExpectedTags) {
        boolean found = false;
        ListIterator<JavadocTag> it = aTags.listIterator();
        while (it.hasNext()) {
            JavadocTag jt = it.next();
            if (!jt.isReturnTag()) continue;
            if (found) {
                this.log(jt.getLineNo(), jt.getColumnNo(), "javadoc.duplicateTag", JavadocTagInfo.RETURN.getText());
            }
            found = true;
            it.remove();
        }
        if (!found && !this.mAllowMissingReturnTag && aReportExpectedTags) {
            this.log(aLineNo, "javadoc.return.expected", new Object[0]);
        }
    }

    private void checkThrowsTags(List<JavadocTag> aTags, List<ExceptionInfo> aThrows, boolean aReportExpectedTags) {
        HashSet foundThrows = Sets.newHashSet();
        ListIterator<JavadocTag> tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            ExceptionInfo ei;
            JavadocTag tag = tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            String documentedEx = tag.getArg1();
            AbstractTypeAwareCheck.Token token = new AbstractTypeAwareCheck.Token(tag.getArg1(), tag.getLineNo(), tag.getColumnNo());
            AbstractTypeAwareCheck.ClassInfo documentedCI = this.createClassInfo(token, this.getCurrentClassName());
            boolean found = foundThrows.contains(documentedEx);
            ListIterator<ExceptionInfo> throwIt = aThrows.listIterator();
            while (!found && throwIt.hasNext()) {
                ei = throwIt.next();
                if (!ei.getName().getText().equals(documentedCI.getName().getText())) continue;
                found = true;
                ei.setFound();
                foundThrows.add(documentedEx);
            }
            throwIt = aThrows.listIterator();
            while (!found && throwIt.hasNext()) {
                ei = throwIt.next();
                if (documentedCI.getClazz() == ei.getClazz()) {
                    found = true;
                    ei.setFound();
                    foundThrows.add(documentedEx);
                    continue;
                }
                if (!this.mAllowThrowsTagsForSubclasses) continue;
                found = this.isSubclass(documentedCI.getClazz(), ei.getClazz());
            }
            if (found) continue;
            boolean reqd = true;
            if (this.mAllowUndeclaredRTE) {
                boolean bl = reqd = !this.isUnchecked(documentedCI.getClazz());
            }
            if (!reqd) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), "javadoc.unusedTag", JavadocTagInfo.THROWS.getText(), tag.getArg1());
        }
        if (!this.mAllowMissingThrowsTags && aReportExpectedTags) {
            for (ExceptionInfo ei : aThrows) {
                if (ei.isFound()) continue;
                AbstractTypeAwareCheck.Token fi = ei.getName();
                this.log(fi.getLineNo(), fi.getColumnNo(), "javadoc.expectedTag", JavadocTagInfo.THROWS.getText(), fi.getText());
            }
        }
    }

    private boolean isSetterMethod(DetailAST aAST) {
        if (aAST.getType() != 9 || aAST.getChildCount() != 7) {
            return false;
        }
        DetailAST type = aAST.findFirstToken(13);
        String name = type.getNextSibling().getText();
        if (!name.matches("^set[A-Z].*")) {
            return false;
        }
        if (type.getChildCount(49) == 0) {
            return false;
        }
        DetailAST params = aAST.findFirstToken(20);
        if (params == null || params.getChildCount(21) != 1) {
            return false;
        }
        DetailAST slist = aAST.findFirstToken(7);
        if (slist == null || slist.getChildCount() != 3) {
            return false;
        }
        DetailAST expr = slist.getFirstChild();
        return expr.getType() == 28 && expr.getFirstChild().getType() == 80;
    }

    private boolean isGetterMethod(DetailAST aAST) {
        if (aAST.getType() != 9 || aAST.getChildCount() != 7) {
            return false;
        }
        DetailAST type = aAST.findFirstToken(13);
        String name = type.getNextSibling().getText();
        if (!name.matches("^(is|get)[A-Z].*")) {
            return false;
        }
        if (type.getChildCount(49) > 0) {
            return false;
        }
        DetailAST params = aAST.findFirstToken(20);
        if (params == null || params.getChildCount(21) > 0) {
            return false;
        }
        DetailAST slist = aAST.findFirstToken(7);
        if (slist == null || slist.getChildCount() != 2) {
            return false;
        }
        DetailAST expr = slist.getFirstChild();
        return expr.getType() == 88 && expr.getFirstChild().getType() == 28;
    }

    private boolean isOverrideMethod(DetailAST aAST) {
        if (9 != aAST.getType() || 5 != aAST.getFirstChild().getType()) {
            return false;
        }
        for (DetailAST node = aAST.getFirstChild().getFirstChild(); null != node && 159 == node.getType(); node = node.getNextSibling()) {
            if (node.getFirstChild().getType() != 170 || node.getFirstChild().getNextSibling().getType() != 58 || !"Override".equals(node.getFirstChild().getNextSibling().getText())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExceptionInfo {
        private boolean mFound;
        private final AbstractTypeAwareCheck.ClassInfo mClassInfo;

        ExceptionInfo(AbstractTypeAwareCheck.Token aIdent, String aCurrentClass) {
            this.mClassInfo = JavadocMethodCheck.this.createClassInfo(aIdent, aCurrentClass);
        }

        final void setFound() {
            this.mFound = true;
        }

        final boolean isFound() {
            return this.mFound;
        }

        final AbstractTypeAwareCheck.Token getName() {
            return this.mClassInfo.getName();
        }

        final Class<?> getClazz() {
            return this.mClassInfo.getClazz();
        }
    }
}

