/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;
import java.util.regex.Pattern;

public class LocalVariableNameCheck
extends AbstractNameCheck {
    private boolean mAllowOneCharVarInForLoop;
    private static Pattern sSingleChar = Utils.getPattern("^[a-z]$");

    public LocalVariableNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public final void setAllowOneCharVarInForLoop(boolean aAllow) {
        this.mAllowOneCharVarInForLoop = aAllow;
    }

    public int[] getDefaultTokens() {
        return new int[]{10, 21};
    }

    protected final boolean mustCheckName(DetailAST aAST) {
        boolean isFinal;
        DetailAST modifiersAST = aAST.findFirstToken(5);
        boolean bl = isFinal = modifiersAST != null && modifiersAST.branchContains(39);
        if (this.mAllowOneCharVarInForLoop && this.isForLoopVariable(aAST)) {
            String variableName = aAST.findFirstToken(58).getText();
            return !sSingleChar.matcher(variableName).find();
        }
        return !isFinal && ScopeUtils.isLocalVariableDef(aAST);
    }

    private boolean isForLoopVariable(DetailAST aVariableDef) {
        int parentType = aVariableDef.getParent().getType();
        return parentType == 35 || parentType == 156;
    }
}

