/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.CommonHiddenStreamToken;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PropertyCacheFile;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaLexer;
import com.puppycrawl.tools.checkstyle.grammars.GeneratedJavaRecognizer;
import java.io.File;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TreeWalker
extends AbstractFileSetCheck {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private final Multimap<String, Check> mTokenToOrdinaryChecks = HashMultimap.create();
    private final Multimap<String, Check> mTokenToCommentChecks = HashMultimap.create();
    private final Set<Check> mOrdinaryChecks = Sets.newHashSet();
    private final Set<Check> mCommentChecks = Sets.newHashSet();
    private int mTabWidth = 8;
    private PropertyCacheFile mCache = new PropertyCacheFile(null, null);
    private ClassLoader mClassLoader;
    private Context mChildContext;
    private ModuleFactory mModuleFactory;
    private static final Log LOG = LogFactory.getLog((String)"com.puppycrawl.tools.checkstyle.TreeWalker");

    public TreeWalker() {
        this.setFileExtensions(new String[]{"java"});
    }

    public void setTabWidth(int aTabWidth) {
        this.mTabWidth = aTabWidth;
    }

    public void setCacheFile(String aFileName) {
        Configuration configuration = this.getConfiguration();
        this.mCache = new PropertyCacheFile(configuration, aFileName);
    }

    public void setClassLoader(ClassLoader aClassLoader) {
        this.mClassLoader = aClassLoader;
    }

    public void setModuleFactory(ModuleFactory aModuleFactory) {
        this.mModuleFactory = aModuleFactory;
    }

    @Override
    public void finishLocalSetup() {
        DefaultContext checkContext = new DefaultContext();
        checkContext.add("classLoader", this.mClassLoader);
        checkContext.add("messages", this.getMessageCollector());
        checkContext.add("severity", this.getSeverity());
        checkContext.add("tabWidth", String.valueOf(this.mTabWidth));
        this.mChildContext = checkContext;
    }

    @Override
    public void setupChild(Configuration aChildConf) throws CheckstyleException {
        String name = aChildConf.getName();
        Object module = this.mModuleFactory.createModule(name);
        if (!(module instanceof Check)) {
            throw new CheckstyleException("TreeWalker is not allowed as a parent of " + name);
        }
        Check c = (Check)module;
        c.contextualize(this.mChildContext);
        c.configure(aChildConf);
        c.init();
        this.registerCheck(c);
    }

    @Override
    protected void processFiltered(File aFile, List<String> aLines) {
        long timestamp;
        String fileName = aFile.getPath();
        if (this.mCache.alreadyChecked(fileName, timestamp = aFile.lastModified())) {
            return;
        }
        try {
            FileText text = FileText.fromLines(aFile, aLines);
            FileContents contents = new FileContents(text);
            DetailAST rootAST = TreeWalker.parse(contents);
            this.getMessageCollector().reset();
            this.walk(rootAST, contents, AstState.ORDINARY);
            DetailAST astWithComments = TreeWalker.appendHiddenCommentNodes(rootAST);
            this.walk(astWithComments, contents, AstState.WITH_COMMENTS);
        }
        catch (RecognitionException re) {
            Utils.getExceptionLogger().debug((Object)"RecognitionException occured.", (Throwable)re);
            this.getMessageCollector().add(new LocalizedMessage(re.getLine(), re.getColumn(), "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{re.getMessage()}, this.getId(), this.getClass(), null));
        }
        catch (TokenStreamRecognitionException tre) {
            Utils.getExceptionLogger().debug((Object)"TokenStreamRecognitionException occured.", (Throwable)tre);
            RecognitionException re = tre.recog;
            if (re != null) {
                this.getMessageCollector().add(new LocalizedMessage(re.getLine(), re.getColumn(), "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{re.getMessage()}, this.getId(), this.getClass(), null));
            } else {
                this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{"TokenStreamRecognitionException occured."}, this.getId(), this.getClass(), null));
            }
        }
        catch (TokenStreamException te) {
            Utils.getExceptionLogger().debug((Object)"TokenStreamException occured.", (Throwable)te);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{te.getMessage()}, this.getId(), this.getClass(), null));
        }
        catch (Throwable err) {
            err.printStackTrace();
            Utils.getExceptionLogger().debug((Object)"Throwable occured.", err);
            this.getMessageCollector().add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{"" + err}, this.getId(), this.getClass(), null));
        }
        if (this.getMessageCollector().size() == 0) {
            this.mCache.checkedOk(fileName, timestamp);
        }
    }

    private void registerCheck(Check aCheck) throws CheckstyleException {
        int[] tokens;
        Set<String> checkTokens = aCheck.getTokenNames();
        if (!checkTokens.isEmpty()) {
            tokens = aCheck.getRequiredTokens();
            int[] acceptableTokens = aCheck.getAcceptableTokens();
            Arrays.sort(acceptableTokens);
            for (String token : checkTokens) {
                try {
                    int tokenId = TokenTypes.getTokenId(token);
                    if (Arrays.binarySearch(acceptableTokens, tokenId) < 0) continue;
                    this.registerCheck(token, aCheck);
                }
                catch (IllegalArgumentException ex) {
                    throw new CheckstyleException("illegal token \"" + token + "\" in check " + aCheck, ex);
                }
            }
        } else {
            tokens = aCheck.getDefaultTokens();
        }
        for (int element : tokens) {
            this.registerCheck(element, aCheck);
        }
        if (aCheck.isCommentNodesRequired()) {
            this.mCommentChecks.add(aCheck);
        } else {
            this.mOrdinaryChecks.add(aCheck);
        }
    }

    private void registerCheck(int aTokenID, Check aCheck) {
        this.registerCheck(TokenTypes.getTokenName(aTokenID), aCheck);
    }

    private void registerCheck(String aToken, Check aCheck) {
        if (aCheck.isCommentNodesRequired()) {
            this.mTokenToCommentChecks.put((Object)aToken, (Object)aCheck);
        } else if (TokenTypes.isCommentType(aToken)) {
            LOG.warn((Object)("Check '" + aCheck.getClass().getName() + "' waits for comment type token ('" + aToken + "') and should override 'isCommentNodesRequred()'" + " method to return 'true'"));
        } else {
            this.mTokenToOrdinaryChecks.put((Object)aToken, (Object)aCheck);
        }
    }

    private void walk(DetailAST aAST, FileContents aContents, AstState aAstState) {
        this.notifyBegin(aAST, aContents, aAstState);
        if (aAST != null) {
            this.processIter(aAST, aAstState);
        }
        this.notifyEnd(aAST, aAstState);
    }

    private void notifyBegin(DetailAST aRootAST, FileContents aContents, AstState aAstState) {
        Set<Check> checks = aAstState == AstState.WITH_COMMENTS ? this.mCommentChecks : this.mOrdinaryChecks;
        for (Check ch : checks) {
            ch.setFileContents(aContents);
            ch.beginTree(aRootAST);
        }
    }

    private void notifyEnd(DetailAST aRootAST, AstState aAstState) {
        Set<Check> checks = aAstState == AstState.WITH_COMMENTS ? this.mCommentChecks : this.mOrdinaryChecks;
        for (Check ch : checks) {
            ch.finishTree(aRootAST);
        }
    }

    private void notifyVisit(DetailAST aAST, AstState aAstState) {
        String tokenType = TokenTypes.getTokenName(aAST.getType());
        Collection visitors = aAstState == AstState.WITH_COMMENTS ? this.mTokenToCommentChecks.get((Object)tokenType) : this.mTokenToOrdinaryChecks.get((Object)tokenType);
        for (Check c : visitors) {
            c.visitToken(aAST);
        }
    }

    private void notifyLeave(DetailAST aAST, AstState aAstState) {
        String tokenType = TokenTypes.getTokenName(aAST.getType());
        Collection visitors = aAstState == AstState.WITH_COMMENTS ? this.mTokenToCommentChecks.get((Object)tokenType) : this.mTokenToOrdinaryChecks.get((Object)tokenType);
        for (Check ch : visitors) {
            ch.leaveToken(aAST);
        }
    }

    public static DetailAST parse(FileContents aContents) throws RecognitionException, TokenStreamException {
        String fullText = aContents.getText().getFullText().toString();
        StringReader sr = new StringReader(fullText);
        GeneratedJavaLexer lexer = new GeneratedJavaLexer(sr);
        lexer.setFilename(aContents.getFilename());
        lexer.setCommentListener(aContents);
        lexer.setTreatAssertAsKeyword(true);
        lexer.setTreatEnumAsKeyword(true);
        lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
        filter.hide(151);
        filter.hide(152);
        GeneratedJavaRecognizer parser = new GeneratedJavaRecognizer((TokenStream)filter);
        parser.setFilename(aContents.getFilename());
        parser.setASTNodeClass(DetailAST.class.getName());
        parser.compilationUnit();
        return (DetailAST)parser.getAST();
    }

    @Override
    public void destroy() {
        for (Check c : this.mOrdinaryChecks) {
            c.destroy();
        }
        for (Check c : this.mCommentChecks) {
            c.destroy();
        }
        this.mCache.destroy();
        super.destroy();
    }

    private void processIter(DetailAST aRoot, AstState aAstState) {
        DetailAST curNode = aRoot;
        while (curNode != null) {
            this.notifyVisit(curNode, aAstState);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.notifyLeave(curNode, aAstState);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    private static DetailAST appendHiddenCommentNodes(DetailAST aRoot) {
        DetailAST newCommentNode;
        DetailAST currentSibling;
        DetailAST result = aRoot;
        DetailAST curNode = aRoot;
        DetailAST lastNode = aRoot;
        while (curNode != null) {
            if (TreeWalker.isPositionGreater(curNode, lastNode)) {
                lastNode = curNode;
            }
            currentSibling = curNode;
            for (CommonHiddenStreamToken tokenBefore = curNode.getHiddenBefore(); tokenBefore != null; tokenBefore = tokenBefore.getHiddenBefore()) {
                newCommentNode = TreeWalker.createCommentAstFromToken((Token)tokenBefore);
                currentSibling.addPreviousSibling(newCommentNode);
                if (currentSibling == result) {
                    result = newCommentNode;
                }
                currentSibling = newCommentNode;
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        if (lastNode != null) {
            currentSibling = lastNode;
            for (CommonHiddenStreamToken tokenAfter = lastNode.getHiddenAfter(); tokenAfter != null; tokenAfter = tokenAfter.getHiddenAfter()) {
                newCommentNode = TreeWalker.createCommentAstFromToken((Token)tokenAfter);
                currentSibling.addNextSibling(newCommentNode);
                currentSibling = newCommentNode;
            }
        }
        return result;
    }

    private static boolean isPositionGreater(DetailAST aAST1, DetailAST aAst2) {
        if (aAST1.getLineNo() > aAst2.getLineNo()) {
            return true;
        }
        if (aAST1.getLineNo() < aAst2.getLineNo()) {
            return false;
        }
        return aAST1.getColumnNo() > aAst2.getColumnNo();
    }

    private static DetailAST createCommentAstFromToken(Token aToken) {
        switch (aToken.getType()) {
            case 151: {
                return TreeWalker.createSlCommentNode(aToken);
            }
            case 152: {
                return TreeWalker.createBlockCommentNode(aToken);
            }
        }
        throw new IllegalArgumentException("Unknown comment type");
    }

    private static DetailAST createSlCommentNode(Token aToken) {
        DetailAST slComment = new DetailAST();
        slComment.setType(151);
        slComment.setText("//");
        slComment.setColumnNo(aToken.getColumn() - 1);
        slComment.setLineNo(aToken.getLine());
        DetailAST slCommentContent = new DetailAST();
        slCommentContent.initialize(aToken);
        slCommentContent.setType(154);
        slCommentContent.setColumnNo(aToken.getColumn() - 1 + 2);
        slCommentContent.setLineNo(aToken.getLine());
        slCommentContent.setText(aToken.getText());
        slComment.addChild((AST)slCommentContent);
        return slComment;
    }

    private static DetailAST createBlockCommentNode(Token aToken) {
        DetailAST blockComment = new DetailAST();
        blockComment.initialize(152, "/*");
        blockComment.setColumnNo(aToken.getColumn() - 1);
        blockComment.setLineNo(aToken.getLine());
        DetailAST blockCommentContent = new DetailAST();
        blockCommentContent.initialize(aToken);
        blockCommentContent.setType(154);
        blockCommentContent.setColumnNo(aToken.getColumn() - 1 + 2);
        blockCommentContent.setLineNo(aToken.getLine());
        blockCommentContent.setText(aToken.getText());
        DetailAST blockCommentClose = new DetailAST();
        blockCommentClose.initialize(153, "*/");
        Map.Entry<Integer, Integer> linesColumns = TreeWalker.countLinesColumns(aToken.getText(), aToken.getLine(), aToken.getColumn());
        blockCommentClose.setLineNo(linesColumns.getKey());
        blockCommentClose.setColumnNo(linesColumns.getValue());
        blockComment.addChild((AST)blockCommentContent);
        blockComment.addChild((AST)blockCommentClose);
        return blockComment;
    }

    private static Map.Entry<Integer, Integer> countLinesColumns(String aText, int aInitialLinesCnt, int aInitialColumnsCnt) {
        int lines = aInitialLinesCnt;
        int columns = aInitialColumnsCnt;
        block3: for (char c : aText.toCharArray()) {
            switch (c) {
                case '\n': {
                    ++lines;
                    columns = 0;
                    continue block3;
                }
                default: {
                    ++columns;
                }
            }
        }
        return new AbstractMap.SimpleEntry<Integer, Integer>(lines, columns);
    }

    private static enum AstState {
        ORDINARY,
        WITH_COMMENTS;

    }
}

