/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CaseFormat;
import com.google.common.primitives.Ints;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocNodeImpl;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocLexer;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class AbstractJavadocCheck
extends Check {
    private final DescriptiveErrorListener mErrorListener = new DescriptiveErrorListener();
    private DetailAST mBlockCommentAst;

    public abstract int[] getDefaultJavadocTokens();

    public void beginJavadocTree(DetailNode aRootAst) {
    }

    public void finishJavadocTree(DetailNode aRootAst) {
    }

    public void visitJavadocToken(DetailNode aAst) {
    }

    public void leaveJavadocToken(DetailNode aAst) {
    }

    @Override
    public final int[] getDefaultTokens() {
        return new int[]{152};
    }

    @Override
    public final int[] getAcceptableTokens() {
        return super.getAcceptableTokens();
    }

    @Override
    public final int[] getRequiredTokens() {
        return super.getRequiredTokens();
    }

    @Override
    public final boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public final void beginTree(DetailAST aRootAST) {
    }

    @Override
    public final void finishTree(DetailAST aRootAST) {
    }

    @Override
    public final void leaveToken(DetailAST aAST) {
    }

    @Override
    public final void visitToken(DetailAST aBlockCommentAst) {
        this.mBlockCommentAst = aBlockCommentAst;
        String commentContent = JavadocUtils.getBlockCommentContent(aBlockCommentAst);
        if (JavadocUtils.isJavadocComment(commentContent)) {
            String javadocComment = commentContent.substring(1);
            this.mErrorListener.setOffset(aBlockCommentAst.getLineNo() - 1);
            try {
                ParseTree parseTree = this.parseJavadoc(javadocComment);
                DetailNode node = this.convertParseTree2DetailNode(parseTree);
                this.processTree(node);
            }
            catch (IOException e) {
                this.log(aBlockCommentAst.getLineNo(), "javadoc.parse.error", e.getMessage());
            }
            catch (ParseCancellationException e) {
                return;
            }
        }
    }

    protected DetailAST getBlockCommentAst() {
        return this.mBlockCommentAst;
    }

    public DetailNode convertParseTree2DetailNode(ParseTree aRootParseTree) {
        ParseTree currentParseTreeNode = aRootParseTree;
        JavadocNodeImpl rootJavadocNode = this.createJavadocNode(currentParseTreeNode, null, -1);
        int childCount = currentParseTreeNode.getChildCount();
        JavadocNodeImpl[] children = (JavadocNodeImpl[])rootJavadocNode.getChildren();
        for (int i = 0; i < childCount; ++i) {
            JavadocNodeImpl child;
            children[i] = child = this.createJavadocNode(currentParseTreeNode.getChild(i), rootJavadocNode, i);
        }
        JavadocNodeImpl currentJavadocParent = rootJavadocNode;
        ParseTree currentParseTreeParent = currentParseTreeNode;
        while (currentJavadocParent != null) {
            children = (JavadocNodeImpl[])currentJavadocParent.getChildren();
            childCount = children.length;
            for (int i = 0; i < childCount; ++i) {
                JavadocNodeImpl currentJavadocNode = children[i];
                ParseTree currentParseTreeNodeChild = currentParseTreeParent.getChild(i);
                JavadocNodeImpl[] subChildren = (JavadocNodeImpl[])currentJavadocNode.getChildren();
                for (int j = 0; j < subChildren.length; ++j) {
                    JavadocNodeImpl child;
                    subChildren[j] = child = this.createJavadocNode(currentParseTreeNodeChild.getChild(j), currentJavadocNode, j);
                }
            }
            if (childCount > 0) {
                currentJavadocParent = children[0];
                currentParseTreeParent = currentParseTreeParent.getChild(0);
                continue;
            }
            JavadocNodeImpl nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(currentJavadocParent);
            ParseTree nextParseTreeSibling = AbstractJavadocCheck.getNextSibling(currentParseTreeParent);
            if (nextJavadocSibling == null) {
                JavadocNodeImpl tempJavadocParent = (JavadocNodeImpl)currentJavadocParent.getParent();
                ParseTree tempParseTreeParent = currentParseTreeParent.getParent();
                while (nextJavadocSibling == null && tempJavadocParent != null) {
                    nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(tempJavadocParent);
                    nextParseTreeSibling = AbstractJavadocCheck.getNextSibling(tempParseTreeParent);
                    tempJavadocParent = (JavadocNodeImpl)tempJavadocParent.getParent();
                    tempParseTreeParent = tempParseTreeParent.getParent();
                }
            }
            currentJavadocParent = nextJavadocSibling;
            currentParseTreeParent = nextParseTreeSibling;
        }
        return rootJavadocNode;
    }

    private JavadocNodeImpl createJavadocNode(ParseTree aParseTree, DetailNode aParent, int aIndex) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        node.setText(aParseTree.getText());
        node.setColumnNumber(AbstractJavadocCheck.getColumn(aParseTree));
        node.setLineNumber(AbstractJavadocCheck.getLine(aParseTree) + this.mBlockCommentAst.getLineNo());
        node.setIndex(aIndex);
        node.setType(AbstractJavadocCheck.getTokenType(aParseTree));
        node.setParent(aParent);
        node.setChildren(new JavadocNodeImpl[aParseTree.getChildCount()]);
        return node;
    }

    private static ParseTree getNextSibling(ParseTree aNode) {
        if (aNode.getParent() == null) {
            return null;
        }
        ParseTree parent = aNode.getParent();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ParseTree currentNode = parent.getChild(i);
            if (!currentNode.equals(aNode)) continue;
            if (i == childCount - 1) {
                return null;
            }
            return parent.getChild(i + 1);
        }
        return null;
    }

    private static int getTokenType(ParseTree aNode) {
        int tokenType = Integer.MIN_VALUE;
        if (aNode.getChildCount() == 0) {
            tokenType = ((TerminalNode)aNode).getSymbol().getType();
        } else {
            String className = AbstractJavadocCheck.getNodeClassNameWithoutContext(aNode);
            String typeName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, className);
            tokenType = JavadocUtils.getTokenId(typeName);
        }
        return tokenType;
    }

    private static String getNodeClassNameWithoutContext(ParseTree aNode) {
        String className = aNode.getClass().getSimpleName();
        int contextLength = 7;
        return className.substring(0, className.length() - 7);
    }

    private static int getLine(ParseTree aTree) {
        if (aTree instanceof TerminalNode) {
            return ((TerminalNode)aTree).getSymbol().getLine() - 1;
        }
        ParserRuleContext rule = (ParserRuleContext)aTree;
        return rule.start.getLine() - 1;
    }

    private static int getColumn(ParseTree aTree) {
        if (aTree instanceof TerminalNode) {
            return ((TerminalNode)aTree).getSymbol().getCharPositionInLine();
        }
        ParserRuleContext rule = (ParserRuleContext)aTree;
        return rule.start.getCharPositionInLine();
    }

    private ParseTree parseJavadoc(String aBlockComment) throws IOException {
        Charset utf8Charset = Charset.forName("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(aBlockComment.getBytes(utf8Charset));
        ANTLRInputStream input = new ANTLRInputStream((InputStream)in);
        JavadocLexer lexer = new JavadocLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.mErrorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JavadocParser parser = new JavadocParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)this.mErrorListener);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        return parser.javadoc();
    }

    private void processTree(DetailNode aRoot) {
        this.beginJavadocTree(aRoot);
        this.walk(aRoot);
        this.finishJavadocTree(aRoot);
    }

    private void walk(DetailNode aRoot) {
        int[] defaultTokenTypes = this.getDefaultJavadocTokens();
        if (defaultTokenTypes == null) {
            return;
        }
        DetailNode curNode = aRoot;
        while (curNode != null) {
            boolean waitsFor = Ints.contains((int[])defaultTokenTypes, (int)curNode.getType());
            if (waitsFor) {
                this.visitJavadocToken(curNode);
            }
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                if (waitsFor) {
                    this.leaveJavadocToken(curNode);
                }
                if ((toVisit = JavadocUtils.getNextSibling(curNode)) != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    class DescriptiveErrorListener
    extends BaseErrorListener {
        private static final String JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
        private static final String JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
        private int mOffset;

        DescriptiveErrorListener() {
        }

        public void setOffset(int aOffset) {
            this.mOffset = aOffset;
        }

        public void syntaxError(Recognizer<?, ?> aRecognizer, Object aOffendingSymbol, int aLine, int aCharPositionInLine, String aMsg, RecognitionException aEx) {
            int lineNumber = this.mOffset + aLine;
            Token token = (Token)aOffendingSymbol;
            if (JAVADOC_MISSED_HTML_CLOSE.equals(aMsg)) {
                AbstractJavadocCheck.this.log(lineNumber, JAVADOC_MISSED_HTML_CLOSE, token.getText());
                throw new ParseCancellationException();
            }
            if (JAVADOC_WRONG_SINGLETON_TAG.equals(aMsg)) {
                AbstractJavadocCheck.this.log(lineNumber, JAVADOC_WRONG_SINGLETON_TAG, token.getText());
                throw new ParseCancellationException();
            }
            RuleContext ruleContext = aEx.getCtx();
            if (ruleContext != null) {
                int ruleIndex = aEx.getCtx().getRuleIndex();
                String ruleName = aRecognizer.getRuleNames()[ruleIndex];
                String upperCaseRuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ruleName);
                AbstractJavadocCheck.this.log(lineNumber, "javadoc.parse.rule.error", aMsg, upperCaseRuleName);
            } else {
                AbstractJavadocCheck.this.log(lineNumber, "javadoc.parse.token.error", aMsg);
            }
        }
    }
}

