/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.JavadocTokenTypes;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavadocUtils {
    private static final ImmutableMap<String, Integer> TOKEN_NAME_TO_VALUE;
    private static final String[] TOKEN_VALUE_TO_NAME;

    private JavadocUtils() {
    }

    public static JavadocTags getJavadocTags(TextBlock aCmt, JavadocTagType aTagType) {
        String[] text = aCmt.getText();
        ArrayList tags = Lists.newArrayList();
        ArrayList invalidTags = Lists.newArrayList();
        Pattern blockTagPattern = Utils.getPattern("/\\*{2,}\\s*@(\\p{Alpha}+)\\s");
        for (int i = 0; i < text.length; ++i) {
            String s = text[i];
            Matcher blockTagMatcher = blockTagPattern.matcher(s);
            if ((aTagType.equals((Object)JavadocTagType.ALL) || aTagType.equals((Object)JavadocTagType.BLOCK)) && blockTagMatcher.find()) {
                String tagName = blockTagMatcher.group(1);
                String content = s.substring(blockTagMatcher.end(1));
                if (content.endsWith("*/")) {
                    content = content.substring(0, content.length() - 2);
                }
                int line = aCmt.getStartLineNo() + i;
                int col = blockTagMatcher.start(1) - 1;
                if (i == 0) {
                    col += aCmt.getStartColNo();
                }
                if (JavadocTagInfo.isValidName(tagName)) {
                    tags.add(new JavadocTag(line, col, tagName, content.trim()));
                } else {
                    invalidTags.add(new InvalidJavadocTag(line, col, tagName));
                }
            } else if (aTagType.equals((Object)JavadocTagType.ALL) || aTagType.equals((Object)JavadocTagType.INLINE)) {
                int commentOffset;
                String commentContents;
                Pattern commentPattern = Utils.getPattern("^\\s*(?:/\\*{2,}|\\*+)\\s*(.*)");
                Matcher commentMatcher = commentPattern.matcher(s);
                if (!commentMatcher.find()) {
                    commentContents = s;
                    commentOffset = 0;
                } else {
                    commentContents = commentMatcher.group(1);
                    commentOffset = commentMatcher.start(1) - 1;
                }
                Pattern tagPattern = Utils.getPattern(".*?\\{@(\\p{Alpha}+)\\s+(.*?)\\}");
                Matcher tagMatcher = tagPattern.matcher(commentContents);
                while (tagMatcher.find()) {
                    if (tagMatcher.groupCount() != 2) continue;
                    String tagName = tagMatcher.group(1);
                    String tagValue = tagMatcher.group(2).trim();
                    int line = aCmt.getStartLineNo() + i;
                    int col = commentOffset + (tagMatcher.start(1) - 1);
                    if (i == 0) {
                        col += aCmt.getStartColNo();
                    }
                    if (JavadocTagInfo.isValidName(tagName)) {
                        tags.add(new JavadocTag(line, col, tagName, tagValue));
                        continue;
                    }
                    invalidTags.add(new InvalidJavadocTag(line, col, tagName));
                }
            }
            blockTagPattern = Utils.getPattern("^\\s*\\**\\s*@(\\p{Alpha}+)\\s");
        }
        return new JavadocTags(tags, invalidTags);
    }

    public static boolean isJavadocComment(String aCommentContent) {
        boolean result = false;
        if (!aCommentContent.isEmpty()) {
            char docCommentIdentificator = aCommentContent.charAt(0);
            result = docCommentIdentificator == '*';
        }
        return result;
    }

    public static boolean isJavadocComment(DetailAST aBlockCommentBegin) {
        char docCommentIdentificator = JavadocUtils.getBlockCommentContent(aBlockCommentBegin).charAt(0);
        return docCommentIdentificator == '*';
    }

    public static String getBlockCommentContent(DetailAST aBlockCommentBegin) {
        DetailAST commentContent = aBlockCommentBegin.getFirstChild();
        return commentContent.getText();
    }

    public static DetailNode findFirstToken(DetailNode aNode, int aType) {
        DetailNode retVal = null;
        DetailNode i = JavadocUtils.getFirstChild(aNode);
        while (i != null) {
            if (i.getType() == aType) {
                retVal = i;
                break;
            }
            i = JavadocUtils.getNextSibling(i);
        }
        return retVal;
    }

    public static DetailNode getFirstChild(DetailNode aNode) {
        return aNode.getChildren().length > 0 ? aNode.getChildren()[0] : null;
    }

    public static boolean branchContains(DetailNode aNode, int aType) {
        DetailNode curNode = aNode;
        while (curNode != null) {
            if (aType == curNode.getType()) {
                return true;
            }
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                toVisit = JavadocUtils.getNextSibling(curNode);
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            if (curNode == toVisit) break;
            curNode = toVisit;
        }
        return false;
    }

    public static DetailNode getNextSibling(DetailNode aNode) {
        DetailNode[] children;
        int nextSiblingIndex;
        DetailNode parent = aNode.getParent();
        if (parent != null && (nextSiblingIndex = aNode.getIndex() + 1) <= (children = parent.getChildren()).length - 1) {
            return children[nextSiblingIndex];
        }
        return null;
    }

    public static DetailNode getPreviousSibling(DetailNode aNode) {
        DetailNode parent = aNode.getParent();
        if (parent != null) {
            int previousSiblingIndex = aNode.getIndex() - 1;
            DetailNode[] children = parent.getChildren();
            if (previousSiblingIndex >= 0) {
                return children[previousSiblingIndex];
            }
        }
        return null;
    }

    public static String getTokenName(int aID) {
        if (aID == -1) {
            return "EOF";
        }
        if (aID > TOKEN_VALUE_TO_NAME.length - 1) {
            throw new IllegalArgumentException("Unknown javadoc token id. Given id: " + aID);
        }
        String name = TOKEN_VALUE_TO_NAME[aID];
        if (name == null) {
            throw new IllegalArgumentException("Unknown javadoc token id. Given id: " + aID);
        }
        return name;
    }

    public static int getTokenId(String aName) {
        Integer id = (Integer)TOKEN_NAME_TO_VALUE.get((Object)aName);
        if (id == null) {
            throw new IllegalArgumentException("Unknown javadoc token name. Given name " + aName);
        }
        return id;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Field[] fields = JavadocTokenTypes.class.getDeclaredFields();
        String[] tempTokenValueToName = new String[]{};
        for (Field f : fields) {
            if (!Modifier.isPublic(f.getModifiers()) || f.getType() != Integer.TYPE) continue;
            String name = f.getName();
            try {
                int tokenValue = f.getInt(name);
                builder.put((Object)name, (Object)tokenValue);
                if (tokenValue > tempTokenValueToName.length - 1) {
                    String[] temp = new String[tokenValue + 1];
                    System.arraycopy(tempTokenValueToName, 0, temp, 0, tempTokenValueToName.length);
                    tempTokenValueToName = temp;
                }
                if (tokenValue == -1) {
                    tempTokenValueToName[0] = name;
                    continue;
                }
                tempTokenValueToName[tokenValue] = name;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate collection of Javadoc tokens", e);
            }
        }
        TOKEN_NAME_TO_VALUE = builder.build();
        TOKEN_VALUE_TO_NAME = tempTokenValueToName;
    }

    public static enum JavadocTagType {
        BLOCK,
        INLINE,
        ALL;

    }
}

