/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NoWhitespaceBeforeCheck
extends Check {
    private boolean mAllowLineBreaks;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{46, 25, 26};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{46, 25, 26, 60};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        String[] lines = this.getLines();
        String line = lines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        if (before < 0 || Character.isWhitespace(line.charAt(before))) {
            DetailAST sibling;
            if (aAST.getType() == 46 && (sibling = aAST.getPreviousSibling()) != null && sibling.getType() == 36 && sibling.getChildCount() == 0) {
                return;
            }
            boolean flag = !this.mAllowLineBreaks;
            for (int i = 0; !flag && i < before; ++i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                flag = true;
            }
            if (flag) {
                this.log(aAST.getLineNo(), before, "ws.preceded", aAST.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean aAllowLineBreaks) {
        this.mAllowLineBreaks = aAllowLineBreaks;
    }
}

