/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WhitespaceAroundCheck
extends Check {
    private boolean mAllowEmptyCtors;
    private boolean mAllowEmptyMethods;
    private boolean mAllowEmptyTypes;
    private boolean mAllowEmptyLoops;
    private boolean mIgnoreEnhancedForColon = true;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{81, 116, 108, 114, 110, 126, 106, 115, 109, 83, 129, 103, 179, 118, 122, 120, 113, 73, 121, 98, 87, 94, 99, 93, 85, 90, 91, 68, 97, 86, 112, 119, 128, 101, 130, 104, 117, 127, 100, 111, 74, 124, 7, 107, 125, 105, 61, 102, 155, 178};
    }

    public void setAllowEmptyMethods(boolean aAllow) {
        this.mAllowEmptyMethods = aAllow;
    }

    public void setAllowEmptyConstructors(boolean aAllow) {
        this.mAllowEmptyCtors = aAllow;
    }

    public void setIgnoreEnhancedForColon(boolean aIgnore) {
        this.mIgnoreEnhancedForColon = aIgnore;
    }

    public void setAllowEmptyTypes(boolean aAllow) {
        this.mAllowEmptyTypes = aAllow;
    }

    public void setAllowEmptyLoops(boolean aAllow) {
        this.mAllowEmptyLoops = aAllow;
    }

    @Override
    public void visitToken(DetailAST aAST) {
        int currentType = aAST.getType();
        int parentType = aAST.getParent().getType();
        if (!(currentType != 74 && currentType != 73 || parentType != 30 && parentType != 166)) {
            return;
        }
        if (currentType == 61 && parentType == 60) {
            return;
        }
        if (currentType == 7 && parentType == 34) {
            return;
        }
        if (currentType == 83) {
            if (parentType == 96 || parentType == 95) {
                return;
            }
            if (parentType == 160 && this.mIgnoreEnhancedForColon) {
                return;
            }
        }
        if (this.isEmptyMethodBlock(aAST, parentType) || this.isEmptyCtorBlock(aAST, parentType) || this.isEmptyLoop(aAST, parentType)) {
            return;
        }
        if (this.mAllowEmptyTypes && this.isEmptyType(aAST, parentType)) {
            return;
        }
        String[] lines = this.getLines();
        String line = lines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        int after = aAST.getColumnNo() + aAST.getText().length();
        if (before >= 0 && !Character.isWhitespace(line.charAt(before))) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "ws.notPreceded", aAST.getText());
        }
        if (after >= line.length()) {
            return;
        }
        char nextChar = line.charAt(after);
        if (!(Character.isWhitespace(nextChar) || currentType == 90 && aAST.getFirstChild().getType() == 46 || currentType == 74 && (nextChar == ')' || nextChar == ';' || nextChar == ',' || nextChar == '.'))) {
            this.log(aAST.getLineNo(), aAST.getColumnNo() + aAST.getText().length(), "ws.notFollowed", aAST.getText());
        }
    }

    private boolean isEmptyMethodBlock(DetailAST aAST, int aParentType) {
        return this.mAllowEmptyMethods && this.isEmptyBlock(aAST, aParentType, 9);
    }

    private boolean isEmptyCtorBlock(DetailAST aAST, int aParentType) {
        return this.mAllowEmptyCtors && this.isEmptyBlock(aAST, aParentType, 8);
    }

    private boolean isEmptyLoop(DetailAST aAST, int aParentType) {
        return this.mAllowEmptyLoops && (this.isEmptyBlock(aAST, aParentType, 93) || this.isEmptyBlock(aAST, aParentType, 86) || this.isEmptyBlock(aAST, aParentType, 87));
    }

    private boolean isEmptyType(DetailAST aAST, int aParentType) {
        DetailAST typeNode;
        int matchType;
        int type = aAST.getType();
        return !(type != 74 && type != 73 || aParentType != 6 || (matchType = (typeNode = aAST.getParent().getParent()).getType()) != 14 && matchType != 15 && matchType != 158 && matchType != 138 && matchType != 161);
    }

    private boolean isEmptyBlock(DetailAST aAST, int aParentType, int aMatch) {
        int type = aAST.getType();
        if (type == 74) {
            DetailAST grandParent = aAST.getParent().getParent();
            return aParentType == 7 && grandParent.getType() == aMatch;
        }
        return type == 7 && aParentType == aMatch && aAST.getFirstChild().getType() == 74;
    }
}

