/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Set;

public class CovariantEqualsCheck
extends Check {
    private final Set<DetailAST> mEqualsMethods = Sets.newHashSet();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 138};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST aAST) {
        this.mEqualsMethods.clear();
        boolean hasEqualsObject = false;
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 9 || !CheckUtils.isEqualsMethod(child)) continue;
                if (this.hasObjectParameter(child)) {
                    hasEqualsObject = true;
                    continue;
                }
                this.mEqualsMethods.add(child);
            }
            if (!hasEqualsObject) {
                for (DetailAST equalsAST : this.mEqualsMethods) {
                    DetailAST nameNode = equalsAST.findFirstToken(59);
                    this.log(nameNode.getLineNo(), nameNode.getColumnNo(), "covariant.equals", new Object[0]);
                }
            }
        }
    }

    private boolean hasObjectParameter(DetailAST aAST) {
        DetailAST paramsNode = aAST.findFirstToken(20);
        if (paramsNode.getChildCount() != 1) {
            return false;
        }
        DetailAST paramNode = paramsNode.findFirstToken(21);
        DetailAST typeNode = paramNode.findFirstToken(13);
        FullIdent fullIdent = FullIdent.createFullIdentBelow(typeNode);
        String name = fullIdent.getText();
        return "Object".equals(name) || "java.lang.Object".equals(name);
    }
}

