/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.blocks.BlockOption;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EmptyBlockCheck
extends AbstractOptionCheck<BlockOption> {
    public static final String MSG_KEY_BLOCK_NO_STMT = "block.noStmt";
    public static final String MSG_KEY_BLOCK_EMPTY = "block.empty";

    public EmptyBlockCheck() {
        super(BlockOption.STMT, BlockOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{84, 95, 97, 85, 83, 92, 91, 11, 12, 89, 67};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{84, 95, 96, 97, 85, 83, 92, 91, 11, 12, 89, 67, 93, 94, 29};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST slistToken = ast.findFirstToken(7);
        DetailAST leftCurly = slistToken == null ? ast.findFirstToken(72) : slistToken;
        if (leftCurly != null) {
            if (this.getAbstractOption() == BlockOption.STMT) {
                boolean emptyBlock;
                if (leftCurly.getType() == 72) {
                    emptyBlock = leftCurly.getNextSibling().getType() != 33;
                } else {
                    boolean bl = emptyBlock = leftCurly.getChildCount() <= 1;
                }
                if (emptyBlock) {
                    this.log(leftCurly.getLineNo(), leftCurly.getColumnNo(), MSG_KEY_BLOCK_NO_STMT, ast.getText());
                }
            } else if (!this.hasText(leftCurly)) {
                this.log(leftCurly.getLineNo(), leftCurly.getColumnNo(), MSG_KEY_BLOCK_EMPTY, ast.getText());
            }
        }
    }

    protected boolean hasText(DetailAST slistAST) {
        DetailAST rightCurly = slistAST.findFirstToken(73);
        DetailAST rcurlyAST = rightCurly == null ? slistAST.getParent().findFirstToken(73) : rightCurly;
        int slistLineNo = slistAST.getLineNo();
        int slistColNo = slistAST.getColumnNo();
        int rcurlyLineNo = rcurlyAST.getLineNo();
        int rcurlyColNo = rcurlyAST.getColumnNo();
        String[] lines = this.getLines();
        boolean retVal = false;
        if (slistLineNo == rcurlyLineNo) {
            String txt = lines[slistLineNo - 1].substring(slistColNo + 1, rcurlyColNo);
            if (StringUtils.isNotBlank((CharSequence)txt)) {
                retVal = true;
            }
        } else {
            retVal = !lines[slistLineNo - 1].substring(slistColNo + 1).trim().isEmpty() || !lines[rcurlyLineNo - 1].substring(0, rcurlyColNo).trim().isEmpty() ? true : !EmptyBlockCheck.checkIsAllLinesAreWhitespace(lines, slistLineNo, rcurlyLineNo);
        }
        return retVal;
    }

    private static boolean checkIsAllLinesAreWhitespace(String[] lines, int lineFrom, int lineTo) {
        boolean result = true;
        for (int i = lineFrom; i < lineTo - 1; ++i) {
            if (lines[i].trim().isEmpty()) continue;
            result = false;
            break;
        }
        return result;
    }
}

