/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class WriteTagCheck
extends Check {
    public static final String MISSING_TAG = "type.missingTag";
    public static final String WRITE_TAG = "javadoc.writeTag";
    public static final String TAG_FORMAT = "type.tagFormat";
    private Pattern tagRE;
    private Pattern tagFormatRE;
    private String tag;
    private String tagFormat;
    private SeverityLevel tagSeverityLevel = SeverityLevel.INFO;

    public void setTag(String tag) {
        this.tag = tag;
        this.tagRE = CommonUtils.createPattern(tag + "\\s*(.*$)");
    }

    public void setTagFormat(String format) {
        this.tagFormat = format;
        this.tagFormatRE = CommonUtils.createPattern(format);
    }

    public final void setTagSeverity(String severity) {
        this.tagSeverityLevel = SeverityLevel.getInstance(severity);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 9, 8, 155, 161};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock cmt = contents.getJavadocBefore(lineNo = ast.getLineNo());
        if (cmt == null) {
            this.log(lineNo, MISSING_TAG, this.tag);
        } else {
            this.checkTag(lineNo, cmt.getText());
        }
    }

    private void checkTag(int lineNo, String ... comment) {
        if (this.tagRE == null) {
            return;
        }
        int tagCount = 0;
        for (int i = 0; i < comment.length; ++i) {
            String s = comment[i];
            Matcher matcher = this.tagRE.matcher(s);
            if (!matcher.find()) continue;
            ++tagCount;
            int contentStart = matcher.start(1);
            String content = s.substring(contentStart);
            if (this.tagFormatRE != null && !this.tagFormatRE.matcher(content).find()) {
                this.log(lineNo + i - comment.length, TAG_FORMAT, this.tag, this.tagFormat);
                continue;
            }
            this.logTag(lineNo + i - comment.length, this.tag, content);
        }
        if (tagCount == 0) {
            this.log(lineNo, MISSING_TAG, this.tag);
        }
    }

    protected final void logTag(int line, String tagName, String tagValue) {
        String originalSeverity = this.getSeverity();
        this.setSeverity(this.tagSeverityLevel.getName());
        this.log(line, WRITE_TAG, tagName, tagValue);
        this.setSeverity(originalSeverity);
    }
}

