/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.SeverityLevelCounter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Checker
extends AutomaticBean
implements MessageDispatcher {
    private static final Log LOG = LogFactory.getLog(Checker.class);
    private final SeverityLevelCounter counter = new SeverityLevelCounter(SeverityLevel.ERROR);
    private final List<AuditListener> listeners = Lists.newArrayList();
    private final List<FileSetCheck> fileSetChecks = Lists.newArrayList();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private String basedir;
    private String localeCountry = Locale.getDefault().getCountry();
    private String localeLanguage = Locale.getDefault().getLanguage();
    private ModuleFactory moduleFactory;
    private ClassLoader moduleClassLoader;
    private Context childContext;
    private final FilterSet filters = new FilterSet();
    private String[] fileExtensions = ArrayUtils.EMPTY_STRING_ARRAY;
    private SeverityLevel severityLevel = SeverityLevel.ERROR;
    private String charset = System.getProperty("file.encoding", "UTF-8");

    public Checker() {
        this.addListener(this.counter);
    }

    @Override
    public void finishLocalSetup() throws CheckstyleException {
        Locale locale = new Locale(this.localeLanguage, this.localeCountry);
        LocalizedMessage.setLocale(locale);
        if (this.moduleFactory == null) {
            if (this.moduleClassLoader == null) {
                throw new CheckstyleException("if no custom moduleFactory is set, moduleClassLoader must be specified");
            }
            Set<String> packageNames = PackageNamesLoader.getPackageNames(this.moduleClassLoader);
            this.moduleFactory = new PackageObjectFactory(packageNames, this.moduleClassLoader);
        }
        DefaultContext context = new DefaultContext();
        context.add("charset", this.charset);
        context.add("classLoader", this.classLoader);
        context.add("moduleFactory", this.moduleFactory);
        context.add("severity", this.severityLevel.getName());
        context.add("basedir", this.basedir);
        this.childContext = context;
    }

    @Override
    protected void setupChild(Configuration childConf) throws CheckstyleException {
        Object child;
        String name = childConf.getName();
        try {
            child = this.moduleFactory.createModule(name);
            if (child instanceof AutomaticBean) {
                AutomaticBean bean = (AutomaticBean)child;
                bean.contextualize(this.childContext);
                bean.configure(childConf);
            }
        }
        catch (CheckstyleException ex) {
            throw new CheckstyleException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
        }
        if (child instanceof FileSetCheck) {
            FileSetCheck fsc = (FileSetCheck)child;
            fsc.init();
            this.addFileSetCheck(fsc);
        } else if (child instanceof Filter) {
            Filter filter = (Filter)child;
            this.addFilter(filter);
        } else if (child instanceof AuditListener) {
            AuditListener listener = (AuditListener)child;
            this.addListener(listener);
        } else {
            throw new CheckstyleException(name + " is not allowed as a child in Checker");
        }
    }

    public void addFileSetCheck(FileSetCheck fileSetCheck) {
        fileSetCheck.setMessageDispatcher(this);
        this.fileSetChecks.add(fileSetCheck);
    }

    public void addFilter(Filter filter) {
        this.filters.addFilter(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.removeFilter(filter);
    }

    public void destroy() {
        this.listeners.clear();
        this.filters.clear();
    }

    public final void addListener(AuditListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AuditListener listener) {
        this.listeners.remove(listener);
    }

    public int process(List<File> files) throws CheckstyleException {
        this.fireAuditStarted();
        for (FileSetCheck fsc : this.fileSetChecks) {
            fsc.beginProcessing(this.charset);
        }
        for (File file : files) {
            if (!CommonUtils.matchesFileExtension(file, this.fileExtensions)) continue;
            String fileName = file.getAbsolutePath();
            this.fireFileStarted(fileName);
            TreeSet fileMessages = Sets.newTreeSet();
            try {
                FileText theText = new FileText(file.getAbsoluteFile(), this.charset);
                for (FileSetCheck fsc : this.fileSetChecks) {
                    fileMessages.addAll(fsc.process(file, theText));
                }
            }
            catch (IOException ioe) {
                LOG.debug((Object)"IOException occurred.", (Throwable)ioe);
                fileMessages.add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{ioe.getMessage()}, null, this.getClass(), null));
            }
            this.fireErrors(fileName, fileMessages);
            this.fireFileFinished(fileName);
        }
        for (FileSetCheck fsc : this.fileSetChecks) {
            fsc.finishProcessing();
        }
        for (FileSetCheck fsc : this.fileSetChecks) {
            fsc.destroy();
        }
        int errorCount = this.counter.getCount();
        this.fireAuditFinished();
        return errorCount;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    void fireAuditStarted() {
        AuditEvent evt = new AuditEvent(this);
        for (AuditListener listener : this.listeners) {
            listener.auditStarted(evt);
        }
    }

    void fireAuditFinished() {
        AuditEvent evt = new AuditEvent(this);
        for (AuditListener listener : this.listeners) {
            listener.auditFinished(evt);
        }
    }

    @Override
    public void fireFileStarted(String fileName) {
        String stripped = CommonUtils.relativizeAndNormalizePath(this.basedir, fileName);
        AuditEvent evt = new AuditEvent(this, stripped);
        for (AuditListener listener : this.listeners) {
            listener.fileStarted(evt);
        }
    }

    @Override
    public void fireFileFinished(String fileName) {
        String stripped = CommonUtils.relativizeAndNormalizePath(this.basedir, fileName);
        AuditEvent evt = new AuditEvent(this, stripped);
        for (AuditListener listener : this.listeners) {
            listener.fileFinished(evt);
        }
    }

    @Override
    public void fireErrors(String fileName, SortedSet<LocalizedMessage> errors) {
        String stripped = CommonUtils.relativizeAndNormalizePath(this.basedir, fileName);
        for (LocalizedMessage element : errors) {
            AuditEvent evt = new AuditEvent(this, stripped, element);
            if (!this.filters.accept(evt)) continue;
            for (AuditListener listener : this.listeners) {
                listener.addError(evt);
            }
        }
    }

    public final void setFileExtensions(String ... extensions) {
        if (extensions == null) {
            this.fileExtensions = null;
            return;
        }
        this.fileExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            this.fileExtensions[i] = CommonUtils.startsWithChar(extension, '.') ? extension : "." + extension;
        }
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    public void setLocaleCountry(String localeCountry) {
        this.localeCountry = localeCountry;
    }

    public void setLocaleLanguage(String localeLanguage) {
        this.localeLanguage = localeLanguage;
    }

    public final void setSeverity(String severity) {
        this.severityLevel = SeverityLevel.getInstance(severity);
    }

    public final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Deprecated
    public final void setClassloader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public final void setModuleClassLoader(ClassLoader moduleClassLoader) {
        this.moduleClassLoader = moduleClassLoader;
    }

    public void setCharset(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            String message = "unsupported charset: '" + charset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.charset = charset;
    }
}

