/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Locale;
import java.util.Stack;
import org.apache.commons.lang3.ArrayUtils;

public class CommentsIndentationCheck
extends Check {
    public static final String MSG_KEY_SINGLE = "comments.indentation.single";
    public static final String MSG_KEY_BLOCK = "comments.indentation.block";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{144, 145};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{144, 145};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST commentAst) {
        switch (commentAst.getType()) {
            case 144: {
                this.visitSingleLineComment(commentAst);
                break;
            }
            case 145: {
                this.visitBlockComment(commentAst);
                break;
            }
            default: {
                String exceptionMsg = "Unexpected token type: " + commentAst.getText();
                throw new IllegalArgumentException(exceptionMsg);
            }
        }
    }

    private void visitSingleLineComment(DetailAST singleLineComment) {
        DetailAST prevStmt = CommentsIndentationCheck.getPreviousStatementOfSingleLineComment(singleLineComment);
        DetailAST nextStmt = singleLineComment.getNextSibling();
        if (!this.isTrailingSingleLineComment(singleLineComment)) {
            if (CommentsIndentationCheck.isInEmptyCaseBlock(prevStmt, nextStmt)) {
                this.handleSingleLineCommentInEmptyCaseBlock(prevStmt, singleLineComment, nextStmt);
            } else if (CommentsIndentationCheck.isFallThroughSingleLineComment(prevStmt, nextStmt)) {
                this.handleFallThroughtSingleLineComment(prevStmt, singleLineComment, nextStmt);
            } else if (CommentsIndentationCheck.isInEmptyCodeBlock(prevStmt, nextStmt)) {
                this.handleSingleLineCommentInEmptyCodeBlock(singleLineComment, nextStmt);
            } else if (CommentsIndentationCheck.isSingleLineCommentAtTheEndOfTheCodeBlock(nextStmt)) {
                this.handleSIngleLineCommentAtTheEndOfTheCodeBlock(prevStmt, singleLineComment, nextStmt);
            } else if (nextStmt != null && !CommentsIndentationCheck.areSameLevelIndented(singleLineComment, nextStmt, nextStmt)) {
                this.log(singleLineComment.getLineNo(), MSG_KEY_SINGLE, nextStmt.getLineNo(), singleLineComment.getColumnNo(), nextStmt.getColumnNo());
            }
        }
    }

    private static DetailAST getPreviousStatementOfSingleLineComment(DetailAST comment) {
        DetailAST prevStatement = CommentsIndentationCheck.isDistributedPreviousStatement(comment) ? CommentsIndentationCheck.getDistributedPreviousStatementOfSingleLineComment(comment) : CommentsIndentationCheck.getOneLinePreviousStatementOfSingleLineComment(comment);
        return prevStatement;
    }

    private static boolean isDistributedPreviousStatement(DetailAST singleLineComment) {
        DetailAST previousSibling = singleLineComment.getPreviousSibling();
        return CommentsIndentationCheck.isDistributedMethodChainOrConcatenationStatement(singleLineComment, previousSibling) || CommentsIndentationCheck.isDistributedReturnStatement(previousSibling) || CommentsIndentationCheck.isDistributedThrowStatement(previousSibling);
    }

    private static boolean isDistributedMethodChainOrConcatenationStatement(DetailAST comment, DetailAST commentPreviousSibling) {
        boolean destributed = false;
        if (commentPreviousSibling != null && commentPreviousSibling.getType() == 45 && comment.getLineNo() - commentPreviousSibling.getLineNo() == 1) {
            DetailAST currentToken = commentPreviousSibling.getPreviousSibling();
            while (currentToken.getFirstChild() != null) {
                currentToken = currentToken.getFirstChild();
            }
            if (currentToken.getType() != 183 && commentPreviousSibling.getLineNo() != currentToken.getLineNo()) {
                destributed = true;
            }
        }
        return destributed;
    }

    private static boolean isDistributedReturnStatement(DetailAST commentPreviousSibling) {
        DetailAST firstChild;
        DetailAST nextSibling;
        boolean destributed = false;
        if (commentPreviousSibling != null && commentPreviousSibling.getType() == 88 && (nextSibling = (firstChild = commentPreviousSibling.getFirstChild()).getNextSibling()) != null) {
            destributed = true;
        }
        return destributed;
    }

    private static boolean isDistributedThrowStatement(DetailAST commentPreviousSibling) {
        DetailAST firstChild;
        DetailAST nextSibling;
        boolean destributed = false;
        if (commentPreviousSibling != null && commentPreviousSibling.getType() == 90 && (nextSibling = (firstChild = commentPreviousSibling.getFirstChild()).getNextSibling()).getLineNo() != commentPreviousSibling.getLineNo()) {
            destributed = true;
        }
        return destributed;
    }

    private static DetailAST getDistributedPreviousStatementOfSingleLineComment(DetailAST comment) {
        DetailAST previousStatement;
        DetailAST currentToken = comment.getPreviousSibling();
        if (currentToken.getType() == 88 || currentToken.getType() == 90) {
            previousStatement = currentToken;
        } else {
            currentToken = currentToken.getPreviousSibling();
            while (currentToken.getFirstChild() != null) {
                currentToken = currentToken.getFirstChild();
            }
            previousStatement = currentToken;
        }
        return previousStatement;
    }

    private static boolean isInEmptyCaseBlock(DetailAST prevStmt, DetailAST nextStmt) {
        return !(prevStmt == null || nextStmt == null || prevStmt.getType() != 93 && prevStmt.getType() != 33 || nextStmt.getType() != 93 && nextStmt.getType() != 94);
    }

    private static boolean isFallThroughSingleLineComment(DetailAST prevStmt, DetailAST nextStmt) {
        return prevStmt != null && prevStmt.getType() != 93 && nextStmt != null && (nextStmt.getType() == 93 || nextStmt.getType() == 94);
    }

    private static boolean isSingleLineCommentAtTheEndOfTheCodeBlock(DetailAST nextStmt) {
        return nextStmt != null && nextStmt.getType() == 73;
    }

    private static boolean isInEmptyCodeBlock(DetailAST prevStmt, DetailAST nextStmt) {
        return prevStmt != null && nextStmt != null && (prevStmt.getType() == 7 || prevStmt.getType() == 6) && nextStmt.getType() == 73;
    }

    private void handleSingleLineCommentInEmptyCaseBlock(DetailAST prevStmt, DetailAST comment, DetailAST nextStmt) {
        if (comment.getColumnNo() < prevStmt.getColumnNo() || comment.getColumnNo() < nextStmt.getColumnNo()) {
            this.logMultilineIndentation(prevStmt, comment, nextStmt);
        }
    }

    private void handleFallThroughtSingleLineComment(DetailAST prevStmt, DetailAST comment, DetailAST nextStmt) {
        if (!CommentsIndentationCheck.areSameLevelIndented(comment, prevStmt, nextStmt)) {
            this.logMultilineIndentation(prevStmt, comment, nextStmt);
        }
    }

    private void handleSIngleLineCommentAtTheEndOfTheCodeBlock(DetailAST prevStmt, DetailAST comment, DetailAST nextStmt) {
        if (prevStmt != null) {
            if (prevStmt.getType() == 93 || prevStmt.getType() == 33 || prevStmt.getType() == 94 || prevStmt.getType() == 144) {
                if (comment.getColumnNo() < nextStmt.getColumnNo()) {
                    this.log(comment.getLineNo(), MSG_KEY_SINGLE, nextStmt.getLineNo(), comment.getColumnNo(), nextStmt.getColumnNo());
                }
            } else if (!CommentsIndentationCheck.areSameLevelIndented(comment, prevStmt, prevStmt)) {
                this.log(comment.getLineNo(), MSG_KEY_SINGLE, prevStmt.getLineNo(), comment.getColumnNo(), prevStmt.getColumnNo());
            }
        }
    }

    private void handleSingleLineCommentInEmptyCodeBlock(DetailAST comment, DetailAST nextStmt) {
        if (comment.getColumnNo() < nextStmt.getColumnNo()) {
            this.log(comment.getLineNo(), MSG_KEY_SINGLE, nextStmt.getLineNo(), comment.getColumnNo(), nextStmt.getColumnNo());
        }
    }

    private static DetailAST getOneLinePreviousStatementOfSingleLineComment(DetailAST comment) {
        DetailAST previousStatement = null;
        Stack<DetailAST> stack = new Stack<DetailAST>();
        DetailAST root = comment.getParent();
        block0: while (root != null || !stack.empty()) {
            if (!stack.empty()) {
                root = (DetailAST)((Object)stack.pop());
            }
            while (root != null) {
                previousStatement = CommentsIndentationCheck.findPreviousStatementOfSingleLineComment(comment, root);
                if (previousStatement != null) {
                    root = null;
                    stack.clear();
                    continue block0;
                }
                if (root.getNextSibling() != null) {
                    stack.push(root.getNextSibling());
                }
                root = root.getFirstChild();
            }
        }
        return previousStatement;
    }

    private static DetailAST findPreviousStatementOfSingleLineComment(DetailAST comment, DetailAST root) {
        DetailAST previousStatement = null;
        if (root.getLineNo() >= comment.getLineNo()) {
            previousStatement = CommentsIndentationCheck.getPrevStatementFromSwitchBlock(comment);
        }
        DetailAST tokenWhichBeginsTheLine = root.getType() == 28 && root.getFirstChild().getFirstChild() != null ? (root.getFirstChild().getType() == 136 ? root.getFirstChild() : CommentsIndentationCheck.findTokenWhichBeginsTheLine(root)) : (root.getType() == 125 ? root.getFirstChild() : root);
        if (tokenWhichBeginsTheLine != null && CommentsIndentationCheck.isOnPreviousLine(comment, tokenWhichBeginsTheLine)) {
            previousStatement = tokenWhichBeginsTheLine;
        }
        return previousStatement;
    }

    private static DetailAST findTokenWhichBeginsTheLine(DetailAST root) {
        DetailAST tokenWhichBeginsTheLine = CommentsIndentationCheck.isUsingOfObjectReferenceToInvokeMethod(root) ? CommentsIndentationCheck.findStartTokenOfMethodCallChain(root) : root.getFirstChild().findFirstToken(58);
        return tokenWhichBeginsTheLine;
    }

    private static boolean isUsingOfObjectReferenceToInvokeMethod(DetailAST root) {
        return root.getFirstChild().getFirstChild().getFirstChild() != null && root.getFirstChild().getFirstChild().getFirstChild().getNextSibling() != null;
    }

    private static DetailAST findStartTokenOfMethodCallChain(DetailAST root) {
        DetailAST startOfMethodCallChain = root;
        while (startOfMethodCallChain.getFirstChild() != null && startOfMethodCallChain.getFirstChild().getLineNo() == root.getLineNo()) {
            startOfMethodCallChain = startOfMethodCallChain.getFirstChild();
        }
        if (startOfMethodCallChain.getFirstChild() != null) {
            startOfMethodCallChain = startOfMethodCallChain.getFirstChild().getNextSibling();
        }
        return startOfMethodCallChain;
    }

    private static boolean isOnPreviousLine(DetailAST currentStatement, DetailAST checkedStatement) {
        return currentStatement.getLineNo() - checkedStatement.getLineNo() == 1;
    }

    private void logMultilineIndentation(DetailAST prevStmt, DetailAST comment, DetailAST nextStmt) {
        String multilineNoTemplate = "%d, %d";
        this.log(comment.getLineNo(), MSG_KEY_SINGLE, String.format(Locale.getDefault(), "%d, %d", prevStmt.getLineNo(), nextStmt.getLineNo()), comment.getColumnNo(), String.format(Locale.getDefault(), "%d, %d", prevStmt.getColumnNo(), nextStmt.getColumnNo()));
    }

    private static DetailAST getPrevStatementFromSwitchBlock(DetailAST comment) {
        DetailAST prevStmt = null;
        DetailAST parentStatement = comment.getParent();
        if (parentStatement != null) {
            prevStmt = parentStatement.getType() == 33 ? CommentsIndentationCheck.getPrevStatementWhenCommentIsUnderCase(parentStatement) : CommentsIndentationCheck.getPrevCaseToken(parentStatement);
        }
        return prevStmt;
    }

    private static DetailAST getPrevStatementWhenCommentIsUnderCase(DetailAST parentStatement) {
        DetailAST prevStmt = null;
        DetailAST prevBlock = parentStatement.getPreviousSibling();
        if (prevBlock.getLastChild() != null) {
            DetailAST blockBody = prevBlock.getLastChild().getLastChild();
            if (blockBody.getPreviousSibling() != null) {
                blockBody = blockBody.getPreviousSibling();
            }
            prevStmt = blockBody.getType() == 28 ? (CommentsIndentationCheck.isUsingOfObjectReferenceToInvokeMethod(blockBody) ? CommentsIndentationCheck.findStartTokenOfMethodCallChain(blockBody) : blockBody.getFirstChild().getFirstChild()) : (blockBody.getType() == 7 ? blockBody.getParent().getParent() : blockBody);
        }
        return prevStmt;
    }

    private static DetailAST getPrevCaseToken(DetailAST parentStatement) {
        DetailAST parentBlock = parentStatement.getParent();
        DetailAST prevCaseToken = parentBlock != null && parentBlock.getParent() != null && parentBlock.getParent().getPreviousSibling() != null && parentBlock.getParent().getPreviousSibling().getType() == 93 ? parentBlock.getParent().getPreviousSibling() : null;
        return prevCaseToken;
    }

    private static boolean areSameLevelIndented(DetailAST comment, DetailAST prevStmt, DetailAST nextStmt) {
        boolean result = prevStmt == null ? comment.getColumnNo() == nextStmt.getColumnNo() : comment.getColumnNo() == nextStmt.getColumnNo() || comment.getColumnNo() == prevStmt.getColumnNo();
        return result;
    }

    private boolean isTrailingSingleLineComment(DetailAST singleLineComment) {
        String targetSourceLine = this.getLine(singleLineComment.getLineNo() - 1);
        int commentColumnNo = singleLineComment.getColumnNo();
        return !CommonUtils.hasWhitespaceBefore(commentColumnNo, targetSourceLine);
    }

    private void visitBlockComment(DetailAST blockComment) {
        DetailAST nextStatement = blockComment.getNextSibling();
        DetailAST prevStatement = CommentsIndentationCheck.getPrevStatementFromSwitchBlock(blockComment);
        if (nextStatement != null && nextStatement.getType() != 73 && !this.isTrailingBlockComment(blockComment) && !CommentsIndentationCheck.areSameLevelIndented(blockComment, prevStatement, nextStatement)) {
            this.log(blockComment.getLineNo(), MSG_KEY_BLOCK, nextStatement.getLineNo(), blockComment.getColumnNo(), nextStatement.getColumnNo());
        }
    }

    private boolean isTrailingBlockComment(DetailAST blockComment) {
        String commentLine = this.getLine(blockComment.getLineNo() - 1);
        int commentColumnNo = blockComment.getColumnNo();
        return !CommonUtils.hasWhitespaceBefore(commentColumnNo, commentLine) || blockComment.getNextSibling().getLineNo() == blockComment.getLineNo();
    }
}

