/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.google.common.base.Strings;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.checks.regexp.DetectorOptions;
import java.util.regex.Matcher;

class MultilineDetector {
    public static final String REGEXP_EXCEEDED = "regexp.exceeded";
    public static final String REGEXP_MINIMUM = "regexp.minimum";
    public static final String EMPTY = "regexp.empty";
    public static final String STACKOVERFLOW = "regexp.StackOverflowError";
    private final DetectorOptions options;
    private int currentMatches;
    private Matcher matcher;
    private FileText text;

    MultilineDetector(DetectorOptions options) {
        this.options = options;
    }

    public void processLines(FileText fileText) {
        this.text = new FileText(fileText);
        this.resetState();
        if (Strings.isNullOrEmpty((String)this.options.getFormat())) {
            this.options.getReporter().log(0, EMPTY, new Object[0]);
        } else {
            this.matcher = this.options.getPattern().matcher(fileText.getFullText());
            this.findMatch();
            this.finish();
        }
    }

    private void findMatch() {
        try {
            boolean foundMatch = this.matcher.find();
            while (foundMatch) {
                LineColumn start = this.text.lineColumn(this.matcher.start());
                ++this.currentMatches;
                if (this.currentMatches > this.options.getMaximum()) {
                    if (this.options.getMessage().isEmpty()) {
                        this.options.getReporter().log(start.getLine(), REGEXP_EXCEEDED, this.matcher.pattern().toString());
                    } else {
                        this.options.getReporter().log(start.getLine(), this.options.getMessage(), new Object[0]);
                    }
                }
                foundMatch = this.matcher.find();
            }
        }
        catch (StackOverflowError ignored) {
            this.options.getReporter().log(0, STACKOVERFLOW, this.matcher.pattern().toString());
        }
    }

    private void finish() {
        if (this.currentMatches < this.options.getMinimum()) {
            if (this.options.getMessage().isEmpty()) {
                this.options.getReporter().log(0, REGEXP_MINIMUM, this.options.getMinimum(), this.options.getFormat());
            } else {
                this.options.getReporter().log(0, this.options.getMessage(), new Object[0]);
            }
        }
    }

    private void resetState() {
        this.currentMatches = 0;
    }
}

