/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Pattern;

public class PackageNameCheck
extends Check {
    public static final String MSG_KEY = "name.invalidPattern";
    private String format = "^[a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*$";
    private Pattern regexp = Pattern.compile(this.format);

    public final void setFormat(String format) {
        this.format = format;
        this.regexp = CommonUtils.createPattern(format);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nameAST = ast.getLastChild().getPreviousSibling();
        FullIdent full = FullIdent.createFullIdent(nameAST);
        if (!this.regexp.matcher(full.getText()).find()) {
            this.log(full.getLineNo(), full.getColumnNo(), MSG_KEY, full.getText(), this.format);
        }
    }
}

