/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class JavadocTypeCheck
extends Check {
    public static final String JAVADOC_MISSING = "javadoc.missing";
    public static final String UNKNOWN_TAG = "javadoc.unknownTag";
    public static final String TAG_FORMAT = "type.tagFormat";
    public static final String MISSING_TAG = "type.missingTag";
    public static final String UNUSED_TAG = "javadoc.unusedTag";
    public static final String UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    private static final String OPEN_ANGLE_BRACKET = "<";
    private static final String CLOSE_ANGLE_BRACKET = ">";
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern authorFormatPattern;
    private Pattern versionFormatPattern;
    private String authorFormat;
    private String versionFormat;
    private boolean allowMissingParamTags;
    private boolean allowUnknownTags;

    public void setScope(String from) {
        this.scope = Scope.getInstance(from);
    }

    public void setExcludeScope(String excludeScope) {
        this.excludeScope = Scope.getInstance(excludeScope);
    }

    public void setAuthorFormat(String format) {
        this.authorFormat = format;
        this.authorFormatPattern = CommonUtils.createPattern(format);
    }

    public void setVersionFormat(String format) {
        this.versionFormat = format;
        this.versionFormatPattern = CommonUtils.createPattern(format);
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowUnknownTags(boolean flag) {
        this.allowUnknownTags = flag;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.shouldCheck(ast)) {
            int lineNo;
            FileContents contents = this.getFileContents();
            TextBlock textBlock = contents.getJavadocBefore(lineNo = ast.getLineNo());
            if (textBlock == null) {
                this.log(lineNo, JAVADOC_MISSING, new Object[0]);
            } else {
                List<JavadocTag> tags = this.getJavadocTags(textBlock);
                if (ScopeUtils.isOuterMostType(ast)) {
                    this.checkTag(lineNo, tags, JavadocTagInfo.AUTHOR.getName(), this.authorFormatPattern, this.authorFormat);
                    this.checkTag(lineNo, tags, JavadocTagInfo.VERSION.getName(), this.versionFormatPattern, this.versionFormat);
                }
                List<String> typeParamNames = CheckUtils.getTypeParameterNames(ast);
                if (!this.allowMissingParamTags) {
                    for (String typeParamName : typeParamNames) {
                        this.checkTypeParamTag(lineNo, tags, typeParamName);
                    }
                }
                this.checkUnusedTypeParamTags(tags, typeParamNames);
            }
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        DetailAST mods = ast.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope customScope = ScopeUtils.isInInterfaceOrAnnotationBlock(ast) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(ast);
        return customScope.isIn(this.scope) && (surroundingScope == null || surroundingScope.isIn(this.scope)) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || surroundingScope != null && !surroundingScope.isIn(this.excludeScope));
    }

    private List<JavadocTag> getJavadocTags(TextBlock textBlock) {
        JavadocTags tags = JavadocUtils.getJavadocTags(textBlock, JavadocUtils.JavadocTagType.BLOCK);
        if (!this.allowUnknownTags) {
            for (InvalidJavadocTag tag : tags.getInvalidTags()) {
                this.log(tag.getLine(), tag.getCol(), UNKNOWN_TAG, tag.getName());
            }
        }
        return tags.getValidTags();
    }

    private void checkTag(int lineNo, List<JavadocTag> tags, String tagName, Pattern formatPattern, String format) {
        if (formatPattern == null) {
            return;
        }
        int tagCount = 0;
        String tagPrefix = "@";
        for (int i = tags.size() - 1; i >= 0; --i) {
            JavadocTag tag = tags.get(i);
            if (!tag.getTagName().equals(tagName)) continue;
            ++tagCount;
            if (formatPattern.matcher(tag.getFirstArg()).find()) continue;
            this.log(lineNo, TAG_FORMAT, "@" + tagName, format);
        }
        if (tagCount == 0) {
            this.log(lineNo, MISSING_TAG, "@" + tagName);
        }
    }

    private void checkTypeParamTag(int lineNo, List<JavadocTag> tags, String typeParamName) {
        boolean found = false;
        for (int i = tags.size() - 1; i >= 0; --i) {
            JavadocTag tag = tags.get(i);
            if (!tag.isParamTag() || tag.getFirstArg().indexOf(OPEN_ANGLE_BRACKET + typeParamName + CLOSE_ANGLE_BRACKET) != 0) continue;
            found = true;
        }
        if (!found) {
            this.log(lineNo, MISSING_TAG, JavadocTagInfo.PARAM.getText() + " " + OPEN_ANGLE_BRACKET + typeParamName + CLOSE_ANGLE_BRACKET);
        }
    }

    private void checkUnusedTypeParamTags(List<JavadocTag> tags, List<String> typeParamNames) {
        Pattern pattern = Pattern.compile("\\s*<([^>]+)>.*");
        for (int i = tags.size() - 1; i >= 0; --i) {
            String typeParamName;
            Matcher matcher;
            JavadocTag tag = tags.get(i);
            if (!tag.isParamTag() || !(matcher = pattern.matcher(tag.getFirstArg())).find() || typeParamNames.contains(typeParamName = matcher.group(1).trim())) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), UNUSED_TAG, JavadocTagInfo.PARAM.getText(), OPEN_ANGLE_BRACKET + typeParamName + CLOSE_ANGLE_BRACKET);
        }
    }
}

