/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Pattern;

public abstract class AbstractNameCheck
extends Check {
    public static final String MSG_INVALID_PATTERN = "name.invalidPattern";
    private String format;
    private Pattern regexp;

    protected AbstractNameCheck(String format) {
        this.setFormat(format);
    }

    protected abstract boolean mustCheckName(DetailAST var1);

    public final void setFormat(String format) {
        this.format = format;
        this.regexp = CommonUtils.createPattern(format);
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nameAST;
        if (this.mustCheckName(ast) && !this.regexp.matcher((nameAST = ast.findFirstToken(58)).getText()).find()) {
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), MSG_INVALID_PATTERN, nameAST.getText(), this.format);
        }
    }
}

