/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static Scope getScopeFromMods(DetailAST aMods) {
        Scope returnValue = Scope.PACKAGE;
        for (DetailAST token = aMods.getFirstChild(); token != null && returnValue == Scope.PACKAGE; token = token.getNextSibling()) {
            if ("public".equals(token.getText())) {
                returnValue = Scope.PUBLIC;
                continue;
            }
            if ("protected".equals(token.getText())) {
                returnValue = Scope.PROTECTED;
                continue;
            }
            if (!"private".equals(token.getText())) continue;
            returnValue = Scope.PRIVATE;
        }
        return returnValue;
    }

    public static Scope getSurroundingScope(DetailAST node) {
        Scope returnValue = null;
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type == 14 || type == 15 || type == 157 || type == 154) {
                DetailAST mods = token.findFirstToken(5);
                Scope modScope = ScopeUtils.getScopeFromMods(mods);
                if (returnValue != null && !returnValue.isIn(modScope)) continue;
                returnValue = modScope;
                continue;
            }
            if (type != 136) continue;
            returnValue = Scope.ANONINNER;
            break;
        }
        return returnValue;
    }

    public static boolean isInInterfaceBlock(DetailAST node) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null && !returnValue; token = token.getParent()) {
            int type = token.getType();
            if (type == 15) {
                returnValue = true;
                continue;
            }
            if (type == 14 || type == 154 || type == 157 || type == 136) break;
        }
        return returnValue;
    }

    public static boolean isInAnnotationBlock(DetailAST node) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null && !returnValue; token = token.getParent()) {
            int type = token.getType();
            if (type == 157) {
                returnValue = true;
                continue;
            }
            if (type == 14 || type == 154 || type == 15 || type == 136) break;
        }
        return returnValue;
    }

    public static boolean isInInterfaceOrAnnotationBlock(DetailAST node) {
        return ScopeUtils.isInInterfaceBlock(node) || ScopeUtils.isInAnnotationBlock(node);
    }

    public static boolean isInEnumBlock(DetailAST node) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null && !returnValue; token = token.getParent()) {
            int type = token.getType();
            if (type == 154) {
                returnValue = true;
                continue;
            }
            if (type == 15 || type == 157 || type == 14 || type == 136) break;
        }
        return returnValue;
    }

    public static boolean isInCodeBlock(DetailAST node) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type != 9 && type != 8 && type != 11 && type != 12) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public static boolean isOuterMostType(DetailAST node) {
        boolean returnValue = true;
        for (DetailAST parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 14 && parent.getType() != 15 && parent.getType() != 157 && parent.getType() != 154) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    public static boolean isLocalVariableDef(DetailAST node) {
        DetailAST parent;
        boolean localVariableDef = false;
        if (node.getType() == 10) {
            parent = node.getParent();
            int type = parent.getType();
            boolean bl = localVariableDef = type == 7 || type == 35 || type == 156;
        }
        if (node.getType() == 21) {
            parent = node.getParent();
            localVariableDef = parent.getType() == 96;
        }
        return localVariableDef;
    }

    public static boolean isInScope(DetailAST ast, Scope scope) {
        Scope surroundingScopeOfAstToken = ScopeUtils.getSurroundingScope(ast);
        return surroundingScopeOfAstToken == scope;
    }
}

