/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import org.apache.commons.lang3.ArrayUtils;

public class AnnotationLocationCheck
extends AbstractCheck {
    public static final String MSG_KEY_ANNOTATION_LOCATION_ALONE = "annotation.location.alone";
    public static final String MSG_KEY_ANNOTATION_LOCATION = "annotation.location";
    private boolean allowSamelineSingleParameterlessAnnotation = true;
    private boolean allowSamelineParameterizedAnnotation;
    private boolean allowSamelineMultipleAnnotations;

    public final void setAllowSamelineSingleParameterlessAnnotation(boolean allow) {
        this.allowSamelineSingleParameterlessAnnotation = allow;
    }

    public final void setAllowSamelineParameterizedAnnotation(boolean allow) {
        this.allowSamelineParameterizedAnnotation = allow;
    }

    public final void setAllowSamelineMultipleAnnotations(boolean allow) {
        this.allowSamelineMultipleAnnotations = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 153, 9, 8, 10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 153, 9, 8, 10, 21, 156, 23, 81, 19, 163, 136, 59, 160};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST modifiersNode = ast.findFirstToken(5);
        if (AnnotationLocationCheck.hasAnnotations(modifiersNode)) {
            this.checkAnnotations(modifiersNode, AnnotationLocationCheck.getAnnotationLevel(modifiersNode));
        }
    }

    private void checkAnnotations(DetailAST modifierNode, int correctLevel) {
        for (DetailAST annotation = modifierNode.getFirstChild(); annotation != null && annotation.getType() == 158; annotation = annotation.getNextSibling()) {
            boolean hasParameters = AnnotationLocationCheck.isParameterized(annotation);
            if (!this.isCorrectLocation(annotation, hasParameters)) {
                this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_LOCATION_ALONE, AnnotationLocationCheck.getAnnotationName(annotation));
                continue;
            }
            if (annotation.getColumnNo() == correctLevel || AnnotationLocationCheck.hasNodeBefore(annotation)) continue;
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_LOCATION, AnnotationLocationCheck.getAnnotationName(annotation), annotation.getColumnNo(), correctLevel);
        }
    }

    private boolean isCorrectLocation(DetailAST annotation, boolean hasParams) {
        boolean allowingCondition = hasParams ? this.allowSamelineParameterizedAnnotation : this.allowSamelineSingleParameterlessAnnotation;
        return this.allowSamelineMultipleAnnotations || allowingCondition && !AnnotationLocationCheck.hasNodeBefore(annotation) || !allowingCondition && !AnnotationLocationCheck.hasNodeBeside(annotation);
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST identNode = annotation.findFirstToken(58);
        if (identNode == null) {
            identNode = annotation.findFirstToken(59).findFirstToken(58);
        }
        return identNode.getText();
    }

    private static boolean hasNodeAfter(DetailAST annotation) {
        int annotationLineNo = annotation.getLineNo();
        DetailAST nextNode = annotation.getNextSibling();
        if (nextNode == null) {
            nextNode = annotation.getParent().getNextSibling();
        }
        return annotationLineNo == nextNode.getLineNo();
    }

    private static boolean hasNodeBefore(DetailAST annotation) {
        int annotationLineNo = annotation.getLineNo();
        DetailAST previousNode = annotation.getPreviousSibling();
        return previousNode != null && annotationLineNo == previousNode.getLineNo();
    }

    private static boolean hasNodeBeside(DetailAST annotation) {
        return AnnotationLocationCheck.hasNodeBefore(annotation) || AnnotationLocationCheck.hasNodeAfter(annotation);
    }

    private static int getAnnotationLevel(DetailAST modifierNode) {
        return modifierNode.getParent().getColumnNo();
    }

    private static boolean isParameterized(DetailAST annotation) {
        return annotation.findFirstToken(28) != null;
    }

    private static boolean hasAnnotations(DetailAST modifierNode) {
        return modifierNode.findFirstToken(158) != null;
    }
}

