/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;

public class DesignForExtensionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "design.forExtension";

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!ScopeUtils.isInInterfaceOrAnnotationBlock(ast) && !DesignForExtensionCheck.isPrivateOrFinalOrAbstract(ast) && ScopeUtils.getSurroundingScope(ast).isIn(Scope.PROTECTED)) {
            boolean classCanBeSubclassed;
            DetailAST implementation = ast.findFirstToken(7);
            boolean nonEmptyImplementation = implementation == null || implementation.getFirstChild().getType() != 73;
            DetailAST classDef = DesignForExtensionCheck.findContainingClass(ast);
            DetailAST classMods = classDef.findFirstToken(5);
            boolean bl = classCanBeSubclassed = classDef.getType() != 153 && !classMods.branchContains(39);
            if (nonEmptyImplementation && classCanBeSubclassed && DesignForExtensionCheck.hasDefaultOrExplicitNonPrivateCtor(classDef)) {
                String name = ast.findFirstToken(58).getText();
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, name);
            }
        }
    }

    private static boolean isPrivateOrFinalOrAbstract(DetailAST ast) {
        DetailAST modifiers = ast.findFirstToken(5);
        return modifiers.branchContains(61) || modifiers.branchContains(40) || modifiers.branchContains(39) || modifiers.branchContains(64);
    }

    private static boolean hasDefaultOrExplicitNonPrivateCtor(DetailAST classDef) {
        DetailAST objBlock = classDef.findFirstToken(6);
        boolean hasDefaultConstructor = true;
        boolean hasExplicitNonPrivateCtor = false;
        for (DetailAST candidate = objBlock.getFirstChild(); candidate != null; candidate = candidate.getNextSibling()) {
            if (candidate.getType() != 8) continue;
            hasDefaultConstructor = false;
            DetailAST ctorMods = candidate.findFirstToken(5);
            if (ctorMods.branchContains(61)) continue;
            hasExplicitNonPrivateCtor = true;
            break;
        }
        return hasDefaultConstructor || hasExplicitNonPrivateCtor;
    }

    private static DetailAST findContainingClass(DetailAST ast) {
        DetailAST searchAST = ast;
        while (searchAST.getType() != 14 && searchAST.getType() != 153) {
            searchAST = searchAST.getParent();
        }
        return searchAST;
    }
}

