/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FinalLocalVariableCheck
extends AbstractCheck {
    public static final String MSG_KEY = "final.variable";
    private static final int[] ASSIGN_OPERATOR_TYPES = new int[]{25, 26, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 130};
    private static final int[] LOOP_TYPES = new int[]{91, 84, 85};
    private final Deque<ScopeData> scopeStack = new ArrayDeque<ScopeData>();
    private final Deque<Deque<DetailAST>> prevScopeUninitializedVariables = new ArrayDeque<Deque<DetailAST>>();
    private boolean validateEnhancedForLoopVariable;

    public final void setValidateEnhancedForLoopVariable(boolean validateEnhancedForLoopVariable) {
        this.validateEnhancedForLoopVariable = validateEnhancedForLoopVariable;
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{58, 8, 9, 7, 6};
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{58, 8, 9, 7, 6, 10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{58, 8, 9, 7, 6, 10, 21};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 6: 
            case 8: 
            case 9: {
                this.scopeStack.push(new ScopeData());
                break;
            }
            case 7: {
                if (ast.getParent().getType() == 33 && ast.getParent().getParent().findFirstToken(33) != ast.getParent()) break;
                this.storePrevScopeUninitializedVariableData();
                this.scopeStack.push(new ScopeData());
                break;
            }
            case 21: {
                if (FinalLocalVariableCheck.isInLambda(ast) || ast.branchContains(39) || FinalLocalVariableCheck.isInAbstractOrNativeMethod(ast) || ScopeUtils.isInInterfaceBlock(ast)) break;
                this.insertParameter(ast);
                break;
            }
            case 10: {
                if (ast.getParent().getType() == 6 || ast.branchContains(39) || FinalLocalVariableCheck.isVariableInForInit(ast) || !this.shouldCheckEnhancedForLoopVariable(ast)) break;
                this.insertVariable(ast);
                break;
            }
            case 58: {
                int parentType = ast.getParent().getType();
                if (!FinalLocalVariableCheck.isAssignOperator(parentType) || !FinalLocalVariableCheck.isFirstChild(ast)) break;
                this.removeVariable(ast);
                break;
            }
            default: {
                throw new IllegalStateException("Incorrect token type");
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        Map scope = null;
        switch (ast.getType()) {
            case 6: 
            case 8: 
            case 9: {
                scope = this.scopeStack.pop().scope;
                break;
            }
            case 7: {
                DetailAST parent;
                Deque<DetailAST> prevScopeUnitializedVariableData = this.prevScopeUninitializedVariables.peek();
                if (ast.getParent().getType() != 33 || this.findLastChildWhichContainsSpecifiedToken(ast.getParent().getParent(), 33, 7) == ast.getParent()) {
                    scope = this.scopeStack.pop().scope;
                    this.prevScopeUninitializedVariables.pop();
                }
                if (!this.shouldUpdateUninitializedVariables(parent = ast.getParent())) break;
                this.updateUninitializedVariables(prevScopeUnitializedVariableData);
                break;
            }
        }
        if (scope != null) {
            for (DetailAST node : scope.values()) {
                this.log(node.getLineNo(), node.getColumnNo(), MSG_KEY, node.getText());
            }
        }
    }

    private void storePrevScopeUninitializedVariableData() {
        ScopeData scopeData = this.scopeStack.peek();
        ArrayDeque<DetailAST> prevScopeUnitializedVariableData = new ArrayDeque<DetailAST>();
        for (DetailAST variable : scopeData.uninitializedVariables) {
            prevScopeUnitializedVariableData.push(variable);
        }
        this.prevScopeUninitializedVariables.push(prevScopeUnitializedVariableData);
    }

    private void updateUninitializedVariables(Deque<DetailAST> prevScopeUnitializedVariableData) {
        for (DetailAST detailAST : prevScopeUnitializedVariableData) {
            for (ScopeData scopeData : this.scopeStack) {
                DetailAST storedVariable = (DetailAST)((Object)scopeData.scope.get(detailAST.getText()));
                if (storedVariable == null || !FinalLocalVariableCheck.isSameVariables(storedVariable, detailAST) || scopeData.uninitializedVariables.contains((Object)storedVariable)) continue;
                scopeData.uninitializedVariables.push(detailAST);
            }
        }
        for (Deque deque : this.prevScopeUninitializedVariables) {
            for (DetailAST variable : deque) {
                for (ScopeData scopeData : this.scopeStack) {
                    DetailAST storedVariable = (DetailAST)((Object)scopeData.scope.get(variable.getText()));
                    if (storedVariable == null || !FinalLocalVariableCheck.isSameVariables(storedVariable, variable) || scopeData.uninitializedVariables.contains((Object)storedVariable)) continue;
                    scopeData.uninitializedVariables.push(variable);
                }
            }
        }
    }

    private boolean shouldUpdateUninitializedVariables(DetailAST ast) {
        return ast.getType() != 95 && ast.getType() != 96 && ast.getType() != 97 && ast.getType() != 92;
    }

    public DetailAST findLastChildWhichContainsSpecifiedToken(DetailAST ast, int childType, int containType) {
        DetailAST returnValue = null;
        for (DetailAST astIterator = ast.getFirstChild(); astIterator != null; astIterator = astIterator.getNextSibling()) {
            if (astIterator.getType() != childType || !astIterator.branchContains(containType)) continue;
            returnValue = astIterator;
        }
        return returnValue;
    }

    private boolean shouldCheckEnhancedForLoopVariable(DetailAST ast) {
        return this.validateEnhancedForLoopVariable || ast.getParent().getType() != 156;
    }

    private void insertParameter(DetailAST ast) {
        Map scope = this.scopeStack.peek().scope;
        DetailAST astNode = ast.findFirstToken(58);
        scope.put(astNode.getText(), astNode);
    }

    private void insertVariable(DetailAST ast) {
        Map scope = this.scopeStack.peek().scope;
        DetailAST astNode = ast.findFirstToken(58);
        scope.put(astNode.getText(), astNode);
        if (!FinalLocalVariableCheck.isInitialized(astNode)) {
            this.scopeStack.peek().uninitializedVariables.add(astNode);
        }
    }

    private static boolean isInitialized(DetailAST ast) {
        return ast.getParent().getLastChild().getType() == 80;
    }

    private static boolean isFirstChild(DetailAST ast) {
        return ast.getPreviousSibling() == null;
    }

    private void removeVariable(DetailAST ast) {
        Iterator<ScopeData> iterator = this.scopeStack.descendingIterator();
        while (iterator.hasNext()) {
            ScopeData scopeData = iterator.next();
            Map scope = scopeData.scope;
            DetailAST storedVariable = (DetailAST)((Object)scope.get(ast.getText()));
            if (storedVariable == null || !FinalLocalVariableCheck.isSameVariables(storedVariable, ast)) continue;
            if (!FinalLocalVariableCheck.shouldRemoveVariable(scopeData, ast)) break;
            scope.remove(ast.getText());
            break;
        }
    }

    private static boolean shouldRemoveVariable(ScopeData scopeData, DetailAST ast) {
        boolean shouldRemove = true;
        for (DetailAST variable : scopeData.uninitializedVariables) {
            if (!variable.getText().equals(ast.getText())) continue;
            if (FinalLocalVariableCheck.isInTheSameLoop(variable, ast)) {
                shouldRemove = false;
            }
            scopeData.uninitializedVariables.remove((Object)variable);
            break;
        }
        return shouldRemove;
    }

    private static boolean isAssignOperator(int parentType) {
        return Arrays.binarySearch(ASSIGN_OPERATOR_TYPES, parentType) >= 0;
    }

    private static boolean isVariableInForInit(DetailAST variableDef) {
        return variableDef.getParent().getType() == 35;
    }

    private static boolean isInAbstractOrNativeMethod(DetailAST ast) {
        boolean abstractOrNative = false;
        for (DetailAST parent = ast.getParent(); parent != null && !abstractOrNative; parent = parent.getParent()) {
            if (parent.getType() != 9) continue;
            DetailAST modifiers = parent.findFirstToken(5);
            abstractOrNative = modifiers.branchContains(40) || modifiers.branchContains(66);
        }
        return abstractOrNative;
    }

    private static boolean isInLambda(DetailAST paramDef) {
        return paramDef.getParent().getParent().getType() == 181;
    }

    private static DetailAST findFirstUpperNamedBlock(DetailAST ast) {
        DetailAST astTraverse = ast;
        while (astTraverse.getType() != 9 && astTraverse.getType() != 14 && astTraverse.getType() != 154 && astTraverse.getType() != 8) {
            astTraverse = astTraverse.getParent();
        }
        return astTraverse;
    }

    private static boolean isSameVariables(DetailAST ast1, DetailAST ast2) {
        DetailAST classOrMethodOfAst2;
        DetailAST classOrMethodOfAst1 = FinalLocalVariableCheck.findFirstUpperNamedBlock(ast1);
        return classOrMethodOfAst1 == (classOrMethodOfAst2 = FinalLocalVariableCheck.findFirstUpperNamedBlock(ast2));
    }

    private static boolean isInTheSameLoop(DetailAST ast1, DetailAST ast2) {
        DetailAST loop2;
        DetailAST loop1;
        for (loop1 = ast1.getParent(); loop1 != null && !FinalLocalVariableCheck.isLoopAst(loop1.getType()); loop1 = loop1.getParent()) {
        }
        for (loop2 = ast2.getParent(); loop2 != null && !FinalLocalVariableCheck.isLoopAst(loop2.getType()); loop2 = loop2.getParent()) {
        }
        return loop1 == null && loop2 == null || loop1 != null && loop1 == loop2;
    }

    private static boolean isLoopAst(int ast) {
        return Arrays.binarySearch(LOOP_TYPES, ast) >= 0;
    }

    static {
        Arrays.sort(ASSIGN_OPERATOR_TYPES);
        Arrays.sort(LOOP_TYPES);
    }

    private static class ScopeData {
        private final Map<String, DetailAST> scope = new HashMap<String, DetailAST>();
        private final Deque<DetailAST> uninitializedVariables = new ArrayDeque<DetailAST>();

        private ScopeData() {
        }
    }
}

