/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class TranslationCheck
extends AbstractFileSetCheck {
    private final List<File> mPropertyFiles = Lists.newArrayList();
    private String mBasenameSeparator;

    public TranslationCheck() {
        this.setFileExtensions(new String[]{"properties"});
        this.setBasenameSeparator("_");
    }

    @Override
    public void beginProcessing(String aCharset) {
        super.beginProcessing(aCharset);
        this.mPropertyFiles.clear();
    }

    @Override
    protected void processFiltered(File aFile, List<String> aLines) {
        this.mPropertyFiles.add(aFile);
    }

    @Override
    public void finishProcessing() {
        super.finishProcessing();
        Map<String, Set<File>> propFilesMap = TranslationCheck.arrangePropertyFiles(this.mPropertyFiles, this.mBasenameSeparator);
        this.checkPropertyFileSets(propFilesMap);
    }

    private static String extractPropertyIdentifier(File aFile, String aBasenameSeparator) {
        String filePath = aFile.getPath();
        int dirNameEnd = filePath.lastIndexOf(File.separatorChar);
        int baseNameStart = dirNameEnd + 1;
        int underscoreIdx = filePath.indexOf(aBasenameSeparator, baseNameStart);
        int dotIdx = filePath.indexOf(46, baseNameStart);
        int cutoffIdx = underscoreIdx != -1 ? underscoreIdx : dotIdx;
        return filePath.substring(0, cutoffIdx);
    }

    public void setBasenameSeparator(String aBasenameSeparator) {
        this.mBasenameSeparator = aBasenameSeparator;
    }

    private static Map<String, Set<File>> arrangePropertyFiles(List<File> aPropFiles, String aBasenameSeparator) {
        HashMap propFileMap = Maps.newHashMap();
        for (File f : aPropFiles) {
            String identifier = TranslationCheck.extractPropertyIdentifier(f, aBasenameSeparator);
            Set fileSet = (Set)propFileMap.get(identifier);
            if (fileSet == null) {
                fileSet = Sets.newHashSet();
                propFileMap.put(identifier, fileSet);
            }
            fileSet.add(f);
        }
        return propFileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Object> loadKeys(File aFile) {
        HashSet keys = Sets.newHashSet();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(aFile);
            Properties props = new Properties();
            props.load(inStream);
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                keys.add(e.nextElement());
            }
        }
        catch (IOException e) {
            try {
                this.logIOException(e, aFile);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(inStream);
                throw throwable;
            }
            Utils.closeQuietly(inStream);
        }
        Utils.closeQuietly(inStream);
        return keys;
    }

    private void logIOException(IOException aEx, File aFile) {
        Object[] args = null;
        String key = "general.fileNotFound";
        if (!(aEx instanceof FileNotFoundException)) {
            args = new String[]{aEx.getMessage()};
            key = "general.exception";
        }
        LocalizedMessage message = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", key, args, this.getId(), this.getClass(), null);
        TreeSet messages = Sets.newTreeSet();
        messages.add(message);
        this.getMessageDispatcher().fireErrors(aFile.getPath(), messages);
        Utils.getExceptionLogger().debug((Object)"IOException occured.", (Throwable)aEx);
    }

    private void compareKeySets(Set<Object> aKeys, Map<File, Set<Object>> aFileMap) {
        Set<Map.Entry<File, Set<Object>>> fls = aFileMap.entrySet();
        for (Map.Entry<File, Set<Object>> entry : fls) {
            File currentFile = entry.getKey();
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            String path = currentFile.getPath();
            dispatcher.fireFileStarted(path);
            Set<Object> currentKeys = entry.getValue();
            HashSet keysClone = Sets.newHashSet(aKeys);
            keysClone.removeAll(currentKeys);
            if (!keysClone.isEmpty()) {
                for (Object key : keysClone) {
                    this.log(0, "translation.missingKey", key);
                }
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    private void checkPropertyFileSets(Map<String, Set<File>> aPropFiles) {
        Set<Map.Entry<String, Set<File>>> entrySet = aPropFiles.entrySet();
        for (Map.Entry<String, Set<File>> entry : entrySet) {
            Set<File> files = entry.getValue();
            if (files.size() < 2) continue;
            HashSet keys = Sets.newHashSet();
            HashMap fileMap = Maps.newHashMap();
            for (File file : files) {
                Set<Object> fileKeys = this.loadKeys(file);
                keys.addAll(fileKeys);
                fileMap.put(file, fileKeys);
            }
            this.compareKeySets(keys, fileMap);
        }
    }
}

