/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class AnnotationLocationCheck
extends Check {
    private boolean mAllowSamelineSingleParameterlessAnnotation = true;
    private boolean mAllowSamelineParametrizedAnnotation;
    private boolean mAllowSamelineMultipleAnnotations;

    public final void setAllowSamelineSingleParameterlessAnnotation(boolean aAllow) {
        this.mAllowSamelineSingleParameterlessAnnotation = aAllow;
    }

    public final void setAllowSamelineParametrizedAnnotation(boolean aAllow) {
        this.mAllowSamelineParametrizedAnnotation = aAllow;
    }

    public final void setAllowSamelineMultipleAnnotations(boolean aAllow) {
        this.mAllowSamelineMultipleAnnotations = aAllow;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 9, 8, 10};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST modifiersNode = aAST.findFirstToken(5);
        if (AnnotationLocationCheck.hasAnnotations(modifiersNode)) {
            this.checkAnnotations(modifiersNode, AnnotationLocationCheck.getAnnotationLevel(modifiersNode));
        }
    }

    private void checkAnnotations(DetailAST aModifierNode, int aCorrectLevel) {
        for (DetailAST annotation = aModifierNode.getFirstChild(); annotation != null && annotation.getType() == 159; annotation = annotation.getNextSibling()) {
            boolean hasParameters = AnnotationLocationCheck.isParameterized(annotation);
            if (!this.isCorrectLocation(annotation, hasParameters)) {
                this.log(annotation.getLineNo(), "annotation.location.alone", AnnotationLocationCheck.getAnnotationName(annotation));
                continue;
            }
            if (annotation.getColumnNo() == aCorrectLevel || AnnotationLocationCheck.hasNodeBefore(annotation)) continue;
            this.log(annotation.getLineNo(), "annotation.location", AnnotationLocationCheck.getAnnotationName(annotation), annotation.getColumnNo(), aCorrectLevel);
        }
    }

    private boolean isCorrectLocation(DetailAST aAnnotation, boolean aHasParams) {
        boolean allowingCondition = aHasParams ? this.mAllowSamelineParametrizedAnnotation : this.mAllowSamelineSingleParameterlessAnnotation;
        return allowingCondition && !AnnotationLocationCheck.hasNodeBefore(aAnnotation) || !allowingCondition && !AnnotationLocationCheck.hasNodeBeside(aAnnotation) || this.mAllowSamelineMultipleAnnotations;
    }

    private static String getAnnotationName(DetailAST aAnnotation) {
        DetailAST idenNode = aAnnotation.findFirstToken(58);
        if (idenNode == null) {
            idenNode = aAnnotation.findFirstToken(59).findFirstToken(58);
        }
        return idenNode.getText();
    }

    private static boolean hasNodeAfter(DetailAST aAnnotation) {
        int annotationLineNo = aAnnotation.getLineNo();
        DetailAST nextNode = aAnnotation.getNextSibling();
        if (nextNode == null) {
            nextNode = aAnnotation.getParent().getNextSibling();
        }
        return nextNode != null && annotationLineNo == nextNode.getLineNo();
    }

    private static boolean hasNodeBefore(DetailAST aAnnotation) {
        int annotationLineNo = aAnnotation.getLineNo();
        DetailAST previousNode = aAnnotation.getPreviousSibling();
        return previousNode != null && annotationLineNo == previousNode.getLineNo();
    }

    private static boolean hasNodeBeside(DetailAST aAnnotation) {
        return AnnotationLocationCheck.hasNodeBefore(aAnnotation) || AnnotationLocationCheck.hasNodeAfter(aAnnotation);
    }

    private static int getAnnotationLevel(DetailAST aModifierNode) {
        return aModifierNode.getParent().getColumnNo();
    }

    private static boolean isParameterized(DetailAST aAnnotation) {
        return aAnnotation.findFirstToken(28) != null;
    }

    private static boolean hasAnnotations(DetailAST aModifierNode) {
        return aModifierNode.findFirstToken(159) != null;
    }
}

