/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NeedBracesCheck
extends Check {
    private boolean mAllowSingleLineIf;

    public void setAllowSingleLineIf(boolean aAllowSingleLineIf) {
        this.mAllowSingleLineIf = aAllowSingleLineIf;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{85, 92, 91, 83, 84};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST slistAST = aAST.findFirstToken(7);
        boolean isElseIf = false;
        if (aAST.getType() == 92 && aAST.findFirstToken(83) != null) {
            isElseIf = true;
        }
        boolean skipStatement = false;
        if (aAST.getType() == 83) {
            skipStatement = this.isSkipIfBlock(aAST);
        }
        if (slistAST == null && !isElseIf && !skipStatement) {
            this.log(aAST.getLineNo(), "needBraces", aAST.getText());
        }
    }

    private boolean isSkipIfBlock(DetailAST aLiteralIf) {
        return this.mAllowSingleLineIf && NeedBracesCheck.isSingleLineIf(aLiteralIf);
    }

    private static boolean isSingleLineIf(DetailAST aLiteralIf) {
        boolean result = false;
        DetailAST ifBlock = aLiteralIf.getLastChild();
        DetailAST lastElementInIfBlock = ifBlock.getLastChild();
        if (lastElementInIfBlock != null && lastElementInIfBlock.getFirstChild() == null && aLiteralIf.getLineNo() == lastElementInIfBlock.getLineNo()) {
            result = true;
        }
        return result;
    }
}

