/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class IllegalImportCheck
extends Check {
    private String[] mIllegalPkgs;

    public IllegalImportCheck() {
        this.setIllegalPkgs(new String[]{"sun"});
    }

    public void setIllegalPkgs(String[] aFrom) {
        this.mIllegalPkgs = (String[])aFrom.clone();
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 152};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        FullIdent imp = aAST.getType() == 30 ? FullIdent.createFullIdentBelow(aAST) : FullIdent.createFullIdent(aAST.getFirstChild().getNextSibling());
        if (this.isIllegalImport(imp.getText())) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.illegal", imp.getText());
        }
    }

    private boolean isIllegalImport(String aImportText) {
        for (String element : this.mIllegalPkgs) {
            if (!aImportText.startsWith(element + ".")) continue;
            return true;
        }
        return false;
    }
}

