/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;

public class JavaNCSSCheck
extends Check {
    private static final int FILE_MAX_NCSS = 2000;
    private static final int CLASS_MAX_NCSS = 1500;
    private static final int METHOD_MAX_NCSS = 50;
    private int mFileMax = 2000;
    private int mClassMax = 1500;
    private int mMethodMax = 50;
    private FastStack<Counter> mCounters;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 9, 8, 11, 12, 16, 30, 10, 43, 42, 83, 92, 84, 85, 91, 89, 86, 87, 88, 90, 67, 96, 97, 28, 22, 93, 94};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 15, 9, 8, 11, 12, 16, 30, 10, 43, 42, 83, 92, 84, 85, 91, 89, 86, 87, 88, 90, 67, 96, 97, 28, 22, 93, 94};
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.mCounters = new FastStack();
        this.mCounters.push(new Counter());
    }

    @Override
    public void visitToken(DetailAST aAST) {
        int tokenType = aAST.getType();
        if (14 == tokenType || 9 == tokenType || 8 == tokenType || 12 == tokenType || 11 == tokenType) {
            this.mCounters.push(new Counter());
        }
        if (this.isCountable(aAST)) {
            for (Counter c : this.mCounters) {
                c.increment();
            }
        }
    }

    @Override
    public void leaveToken(DetailAST aAST) {
        Counter counter;
        int count;
        int tokenType = aAST.getType();
        if (9 == tokenType || 8 == tokenType || 12 == tokenType || 11 == tokenType) {
            Counter counter2 = this.mCounters.pop();
            int count2 = counter2.getCount();
            if (count2 > this.mMethodMax) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "ncss.method", count2, this.mMethodMax);
            }
        } else if (14 == tokenType && (count = (counter = this.mCounters.pop()).getCount()) > this.mClassMax) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "ncss.class", count, this.mClassMax);
        }
    }

    @Override
    public void finishTree(DetailAST aRootAST) {
        Counter counter = this.mCounters.pop();
        int count = counter.getCount();
        if (count > this.mFileMax) {
            this.log(aRootAST.getLineNo(), aRootAST.getColumnNo(), "ncss.file", count, this.mFileMax);
        }
    }

    public void setFileMaximum(int aFileMax) {
        this.mFileMax = aFileMax;
    }

    public void setClassMaximum(int aClassMax) {
        this.mClassMax = aClassMax;
    }

    public void setMethodMaximum(int aMethodMax) {
        this.mMethodMax = aMethodMax;
    }

    private boolean isCountable(DetailAST aAST) {
        boolean countable = true;
        int tokenType = aAST.getType();
        if (28 == tokenType) {
            countable = this.isExpressionCountable(aAST);
        } else if (10 == tokenType) {
            countable = this.isVariableDefCountable(aAST);
        }
        return countable;
    }

    private boolean isVariableDefCountable(DetailAST aAST) {
        boolean countable = false;
        int parentType = aAST.getParent().getType();
        if (7 == parentType || 6 == parentType) {
            DetailAST prevSibling = aAST.getPreviousSibling();
            countable = prevSibling == null || 74 != prevSibling.getType();
        }
        return countable;
    }

    private boolean isExpressionCountable(DetailAST aAST) {
        boolean countable = true;
        int parentType = aAST.getParent().getType();
        switch (parentType) {
            case 7: 
            case 22: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 92: {
                DetailAST prevSibling = aAST.getPreviousSibling();
                countable = prevSibling == null || 76 != prevSibling.getType();
                break;
            }
            default: {
                countable = false;
            }
        }
        return countable;
    }

    private static class Counter {
        private int mIvCount;

        private Counter() {
        }

        public void increment() {
            ++this.mIvCount;
        }

        public int getCount() {
            return this.mIvCount;
        }
    }
}

