/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AbbreviationAsWordInNameCheck
extends Check {
    public static final String MSG_KEY = "abbreviation.as.word";
    private static final int DEFAULT_ALLOWED_ABBREVIATIONS_LENGTH = 3;
    private int mAllowedAbbreviationLength = 3;
    private Set<String> mAllowedAbbreviations = new HashSet<String>();
    private boolean mIgnoreFinal = true;
    private boolean mIgnoreStatic = true;
    private boolean mIgnoreOverriddenMethods = true;

    public void setIgnoreFinal(boolean aIgnoreFinal) {
        this.mIgnoreFinal = aIgnoreFinal;
    }

    public void setIgnoreStatic(boolean aIgnoreStatic) {
        this.mIgnoreStatic = aIgnoreStatic;
    }

    public void setIgnoreOverriddenMethods(boolean aIgnoreOverriddenMethods) {
        this.mIgnoreOverriddenMethods = aIgnoreOverriddenMethods;
    }

    public void setAllowedAbbreviationLength(int aAllowedAbbreviationLength) {
        this.mAllowedAbbreviationLength = aAllowedAbbreviationLength;
    }

    public void setAllowedAbbreviations(String aAllowedAbbreviations) {
        if (aAllowedAbbreviations != null) {
            this.mAllowedAbbreviations = new HashSet<String>(Arrays.asList(aAllowedAbbreviations.split(",")));
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 157, 161, 21, 10, 9};
    }

    @Override
    public void visitToken(DetailAST aAst) {
        DetailAST nameAst;
        String typeName;
        String abbr;
        if (!this.isIgnoreSituation(aAst) && (abbr = this.getDisallowedAbbreviation(typeName = (nameAst = aAst.findFirstToken(58)).getText())) != null) {
            this.log(nameAst.getLineNo(), MSG_KEY, this.mAllowedAbbreviationLength);
        }
    }

    private boolean isIgnoreSituation(DetailAST aAst) {
        DetailAST modifiers = aAst.getFirstChild();
        boolean result = false;
        if (aAst.getType() == 10) {
            result = (this.mIgnoreFinal || this.mIgnoreStatic) && AbbreviationAsWordInNameCheck.isInterfaceDeclaration(aAst) ? true : this.mIgnoreFinal && modifiers.branchContains(39) || this.mIgnoreStatic && modifiers.branchContains(64);
        } else if (aAst.getType() == 9) {
            result = this.mIgnoreOverriddenMethods && AbbreviationAsWordInNameCheck.hasOverrideAnnotation(modifiers);
        }
        return result;
    }

    private static boolean isInterfaceDeclaration(DetailAST aVariableDefAst) {
        DetailAST astParent2;
        boolean result = false;
        DetailAST astBlock = aVariableDefAst.getParent();
        if (astBlock != null && (astParent2 = astBlock.getParent()) != null && astParent2.getType() == 15) {
            result = true;
        }
        return result;
    }

    private static boolean hasOverrideAnnotation(DetailAST aMethodModifiersAST) {
        boolean result = false;
        for (DetailAST child : AbbreviationAsWordInNameCheck.getChildren(aMethodModifiersAST)) {
            DetailAST annotationIdent;
            if (child.getType() != 159 || (annotationIdent = child.findFirstToken(58)) == null || !"Override".equals(annotationIdent.getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getDisallowedAbbreviation(String aString) {
        int endIndex;
        int abbrLength;
        int beginIndex = 0;
        boolean abbrStarted = false;
        String result = null;
        for (int index = 0; index < aString.length(); ++index) {
            char symbol = aString.charAt(index);
            if (Character.isUpperCase(symbol)) {
                if (abbrStarted) continue;
                abbrStarted = true;
                beginIndex = index;
                continue;
            }
            if (!abbrStarted) continue;
            abbrStarted = false;
            int endIndex2 = index - 1;
            int abbrLength2 = endIndex2 - beginIndex;
            if (abbrLength2 > this.mAllowedAbbreviationLength) {
                result = aString.substring(beginIndex, endIndex2);
                if (!this.mAllowedAbbreviations.contains(result)) break;
                result = null;
            }
            beginIndex = -1;
        }
        if (abbrStarted && (abbrLength = (endIndex = aString.length()) - beginIndex) > 1 && abbrLength > this.mAllowedAbbreviationLength && this.mAllowedAbbreviations.contains(result = aString.substring(beginIndex, endIndex))) {
            result = null;
        }
        return result;
    }

    private static List<DetailAST> getChildren(DetailAST aNode) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = aNode.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }
}

