/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class OuterTypeNumberCheck
extends Check {
    private int mMax = 1;
    private int mCurrentDepth;
    private int mOuterNum;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 157};
    }

    @Override
    public void beginTree(DetailAST aAst) {
        this.mCurrentDepth = 0;
        this.mOuterNum = 0;
    }

    @Override
    public void finishTree(DetailAST aAst) {
        if (this.mMax < this.mOuterNum) {
            this.log(aAst, "maxOuterTypes", this.mOuterNum, this.mMax);
        }
    }

    @Override
    public void visitToken(DetailAST aAst) {
        if (0 == this.mCurrentDepth) {
            ++this.mOuterNum;
        }
        ++this.mCurrentDepth;
    }

    @Override
    public void leaveToken(DetailAST aAst) {
        --this.mCurrentDepth;
    }

    public void setMax(int aTo) {
        this.mMax = aTo;
    }
}

