/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ParameterNumberCheck
extends Check {
    private static final String OVERRIDE = "Override";
    private static final String CANONICAL_OVERRIDE = "java.lang.Override";
    private static final int DEFAULT_MAX_PARAMETERS = 7;
    private int mMax = 7;
    private boolean mIgnoreOverriddenMethods;

    public void setMax(int aMax) {
        this.mMax = aMax;
    }

    public void setIgnoreOverriddenMethods(boolean aIgnoreOverriddenMethods) {
        this.mIgnoreOverriddenMethods = aIgnoreOverriddenMethods;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST params = aAST.findFirstToken(20);
        int count = params.getChildCount(21);
        if (count > this.mMax && !this.ignoreNumberOfParameters(aAST)) {
            DetailAST name = aAST.findFirstToken(58);
            this.log(name.getLineNo(), name.getColumnNo(), "maxParam", this.mMax, count);
        }
    }

    private boolean ignoreNumberOfParameters(DetailAST aAST) {
        return this.mIgnoreOverriddenMethods && (AnnotationUtility.containsAnnotation(aAST, OVERRIDE) || AnnotationUtility.containsAnnotation(aAST, CANONICAL_OVERRIDE));
    }
}

