/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NoWhitespaceAfterCheck
extends Check {
    private boolean mAllowLineBreaks = true;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{29, 129, 130, 31, 32, 131, 132, 59};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{29, 129, 130, 31, 32, 131, 132, 59, 23};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST targetAST = aAST;
        if (targetAST.getType() == 23) {
            targetAST = targetAST.findFirstToken(77);
        }
        String line = this.getLine(aAST.getLineNo() - 1);
        int after = targetAST.getColumnNo() + targetAST.getText().length();
        if (after >= line.length() || Character.isWhitespace(line.charAt(after))) {
            boolean flag = !this.mAllowLineBreaks;
            for (int i = after + 1; !flag && i < line.length(); ++i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                flag = true;
            }
            if (flag) {
                this.log(targetAST.getLineNo(), after, "ws.followed", targetAST.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean aAllowLineBreaks) {
        this.mAllowLineBreaks = aAllowLineBreaks;
    }
}

