/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public final class TokenTypesDoclet {
    private static final String DEST_FILE_OPT = "-destfile";

    private TokenTypesDoclet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc aRoot) throws FileNotFoundException {
        String fileName = TokenTypesDoclet.getDestFileName(aRoot.options());
        FileOutputStream fos = new FileOutputStream(fileName);
        try (PrintStream ps = null;){
            FieldDoc[] fields;
            ps = new PrintStream(fos);
            ClassDoc[] classes = aRoot.classes();
            if (classes.length != 1 || !"TokenTypes".equals(classes[0].name())) {
                String message = "The doclet should be used for TokenTypes only";
                throw new IllegalArgumentException("The doclet should be used for TokenTypes only");
            }
            for (FieldDoc field : fields = classes[0].fields()) {
                if (!field.isStatic() || !field.isPublic() || !field.isFinal() || !"int".equals(field.type().qualifiedTypeName())) continue;
                if (field.firstSentenceTags().length != 1) {
                    String message = "Should be only one tag.";
                    throw new IllegalArgumentException("Should be only one tag.");
                }
                ps.println(field.name() + "=" + field.firstSentenceTags()[0].text());
            }
        }
        return true;
    }

    public static int optionLength(String aOption) {
        if (DEST_FILE_OPT.equals(aOption)) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] aOptions, DocErrorReporter aReporter) {
        boolean foundDestFileOption = false;
        for (String[] opt : aOptions) {
            if (!DEST_FILE_OPT.equals(opt[0])) continue;
            if (foundDestFileOption) {
                aReporter.printError("Only one -destfile option allowed.");
                return false;
            }
            foundDestFileOption = true;
        }
        if (!foundDestFileOption) {
            String message = "Usage: javadoc -destfile file -doclet TokenTypesDoclet ...";
            aReporter.printError("Usage: javadoc -destfile file -doclet TokenTypesDoclet ...");
        }
        return foundDestFileOption;
    }

    private static String getDestFileName(String[][] aOptions) {
        String fileName = null;
        for (String[] opt : aOptions) {
            if (!DEST_FILE_OPT.equals(opt[0])) continue;
            fileName = opt[1];
        }
        return fileName;
    }
}

