/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Utils {
    private static final ConcurrentMap<String, Pattern> CREATED_RES = Maps.newConcurrentMap();
    private static final Log EXCEPTION_LOG = LogFactory.getLog((String)"com.puppycrawl.tools.checkstyle.ExceptionLog");

    private Utils() {
    }

    public static Log getExceptionLogger() {
        return EXCEPTION_LOG;
    }

    public static boolean whitespaceBefore(int index, String line) {
        for (int i = 0; i < index; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int lengthMinusTrailingWhitespace(String line) {
        int len = line.length();
        for (int i = len - 1; i >= 0 && Character.isWhitespace(line.charAt(i)); --i) {
            --len;
        }
        return len;
    }

    public static int lengthExpandedTabs(String string, int toIdx, int tabWidth) {
        int len = 0;
        for (int idx = 0; idx < toIdx; ++idx) {
            if (string.charAt(idx) == '\t') {
                len = (len / tabWidth + 1) * tabWidth;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static Pattern getPattern(String pattern) throws PatternSyntaxException {
        return Utils.getPattern(pattern, 0);
    }

    public static Pattern getPattern(String pattern, int compileFlags) throws PatternSyntaxException {
        String key = pattern + ":flags-" + compileFlags;
        Pattern retVal = (Pattern)CREATED_RES.get(key);
        if (retVal == null) {
            retVal = Pattern.compile(pattern, compileFlags);
            CREATED_RES.putIfAbsent(key, retVal);
        }
        return retVal;
    }

    @Deprecated
    public static String[] getLines(String fileName) throws IOException {
        return Utils.getLines(fileName, System.getProperty("file.encoding", "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String[] getLines(String fileName, String charsetName) throws IOException {
        ArrayList lines = Lists.newArrayList();
        FileInputStream fr = new FileInputStream(fileName);
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new InputStreamReader((InputStream)fr, charsetName));
        }
        catch (UnsupportedEncodingException ex) {
            fr.close();
            String message = "unsupported charset: " + ex.getMessage();
            throw new UnsupportedEncodingException(message);
        }
        try {
            String l;
            while ((l = lnr.readLine()) != null) {
                lines.add(l);
            }
        }
        finally {
            Utils.closeQuietly(lnr);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static Pattern createPattern(String pattern) throws ConversionException {
        Pattern retVal = null;
        try {
            retVal = Utils.getPattern(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("Failed to initialise regexp expression " + pattern, (Throwable)e);
        }
        return retVal;
    }

    public static String baseClassname(String type) {
        int i = type.lastIndexOf(".");
        return i == -1 ? type : type.substring(i + 1);
    }

    public static String getStrippedFileName(String basedir, String fileName) {
        String stripped;
        if (basedir == null || !fileName.startsWith(basedir)) {
            stripped = fileName;
        } else {
            int skipSep = basedir.endsWith(File.separator) ? 0 : 1;
            stripped = fileName.substring(basedir.length() + skipSep);
        }
        return stripped;
    }

    public static void closeQuietly(Closeable shutting) {
        if (null != shutting) {
            try {
                shutting.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

