/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.Arrays;
import java.util.Set;

public class DescendantTokenCheck
extends Check {
    private int minimumDepth;
    private int maximumDepth = Integer.MAX_VALUE;
    private int minimumNumber;
    private int maximumNumber = Integer.MAX_VALUE;
    private boolean sumTokenCounts;
    private int[] limitedTokens = new int[0];
    private String minimumMessage;
    private String maximumMessage;
    private int[] counts = new int[0];

    @Override
    public int[] getDefaultTokens() {
        return new int[0];
    }

    @Override
    public void visitToken(DetailAST ast) {
        Arrays.fill(this.counts, 0);
        this.countTokens((AST)ast, 0);
        String name = TokenTypes.getTokenName(ast.getType());
        if (this.sumTokenCounts) {
            int total = 0;
            for (int element : this.limitedTokens) {
                total += this.counts[element - 1];
            }
            if (total < this.minimumNumber) {
                this.log(ast.getLineNo(), ast.getColumnNo(), null == this.minimumMessage ? "descendant.token.sum.min" : this.minimumMessage, String.valueOf(total), String.valueOf(this.minimumNumber), name);
            }
            if (total > this.maximumNumber) {
                this.log(ast.getLineNo(), ast.getColumnNo(), null == this.maximumMessage ? "descendant.token.sum.max" : this.maximumMessage, String.valueOf(total), String.valueOf(this.maximumNumber), name);
            }
        } else {
            for (int element : this.limitedTokens) {
                String descendantName;
                int tokenCount = this.counts[element - 1];
                if (tokenCount < this.minimumNumber) {
                    descendantName = TokenTypes.getTokenName(element);
                    this.log(ast.getLineNo(), ast.getColumnNo(), null == this.minimumMessage ? "descendant.token.min" : this.minimumMessage, String.valueOf(tokenCount), String.valueOf(this.minimumNumber), name, descendantName);
                }
                if (tokenCount <= this.maximumNumber) continue;
                descendantName = TokenTypes.getTokenName(element);
                this.log(ast.getLineNo(), ast.getColumnNo(), null == this.maximumMessage ? "descendant.token.max" : this.maximumMessage, String.valueOf(tokenCount), String.valueOf(this.maximumNumber), name, descendantName);
            }
        }
    }

    private void countTokens(AST ast, int depth) {
        if (depth <= this.maximumDepth) {
            int type;
            if (depth >= this.minimumDepth && (type = ast.getType()) <= this.counts.length) {
                int n = type - 1;
                this.counts[n] = this.counts[n] + 1;
            }
            int nextDepth = depth + 1;
            for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.countTokens(child, nextDepth);
            }
        }
    }

    @Override
    public int[] getAcceptableTokens() {
        Set<String> tokenNames = this.getTokenNames();
        int[] result = new int[tokenNames.size()];
        int i = 0;
        for (String name : tokenNames) {
            result[i++] = TokenTypes.getTokenId(name);
        }
        return result;
    }

    public void setLimitedTokens(String[] limitedTokensParam) {
        this.limitedTokens = new int[limitedTokensParam.length];
        int maxToken = 0;
        for (int i = 0; i < limitedTokensParam.length; ++i) {
            this.limitedTokens[i] = TokenTypes.getTokenId(limitedTokensParam[i]);
            if (this.limitedTokens[i] <= maxToken) continue;
            maxToken = this.limitedTokens[i];
        }
        this.counts = new int[maxToken];
    }

    public void setMinimumDepth(int minimumDepth) {
        this.minimumDepth = minimumDepth;
    }

    public void setMaximumDepth(int maximumDepth) {
        this.maximumDepth = maximumDepth;
    }

    public void setMinimumNumber(int minimumNumber) {
        this.minimumNumber = minimumNumber;
    }

    public void setMaximumNumber(int maximumNumber) {
        this.maximumNumber = maximumNumber;
    }

    public void setMinimumMessage(String message) {
        this.minimumMessage = message;
    }

    public void setMaximumMessage(String message) {
        this.maximumMessage = message;
    }

    public void setSumTokenCounts(boolean sum) {
        this.sumTokenCounts = sum;
    }
}

