/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;

public class OverloadMethodsDeclarationOrderCheck
extends Check {
    @Override
    public int[] getDefaultTokens() {
        return new int[]{6};
    }

    @Override
    public void visitToken(DetailAST ast) {
        int parentType = ast.getParent().getType();
        if (parentType == 14 || parentType == 154 || parentType == 15 || parentType == 136) {
            this.checkOverloadMethodsGrouping(ast);
        }
    }

    private void checkOverloadMethodsGrouping(DetailAST objectBlock) {
        boolean allowedDistance = true;
        HashMap<String, Integer> methodIndexMap = new HashMap<String, Integer>();
        HashMap<String, Integer> methodLineNumberMap = new HashMap<String, Integer>();
        int currentIndex = 0;
        for (DetailAST currentToken = objectBlock.getFirstChild(); currentToken != null; currentToken = currentToken.getNextSibling()) {
            int priviousIndex;
            if (currentToken.getType() != 9) continue;
            String methodName = currentToken.findFirstToken(58).getText();
            if (methodIndexMap.containsKey(methodName) && ++currentIndex - (priviousIndex = ((Integer)methodIndexMap.get(methodName)).intValue()) > 1) {
                int previousLineWithOverloadMethod = (Integer)methodLineNumberMap.get(methodName);
                this.log(currentToken.getLineNo(), "overload.methods.declaration", previousLineWithOverloadMethod);
            }
            methodIndexMap.put(methodName, currentIndex);
            methodLineNumberMap.put(methodName, currentToken.getLineNo());
        }
    }
}

