/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.DeclarationCollector;

public class RequireThisCheck
extends DeclarationCollector {
    private boolean checkFields = true;
    private boolean checkMethods = true;

    public void setCheckFields(boolean checkFields) {
        this.checkFields = checkFields;
    }

    public boolean getCheckFields() {
        return this.checkFields;
    }

    public void setCheckMethods(boolean checkMethods) {
        this.checkMethods = checkMethods;
    }

    public boolean getCheckMethods() {
        return this.checkMethods;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 8, 154, 58, 15, 9, 21, 7, 10};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        super.visitToken(ast);
        if (ast.getType() == 58) {
            this.processIDENT(ast);
        }
    }

    private void processIDENT(DetailAST ast) {
        int parentType = ast.getParent().getType();
        if (parentType == 160 || parentType == 159 || parentType == 161) {
            return;
        }
        if (parentType == 27) {
            if (this.checkMethods && this.isClassMethod(ast.getText())) {
                this.log(ast, "require.this.method", ast.getText());
            }
            return;
        }
        if (!this.checkFields) {
            return;
        }
        if (ScopeUtils.getSurroundingScope(ast) == null) {
            return;
        }
        if (parentType == 59 && ast.getPreviousSibling() != null) {
            return;
        }
        if (parentType == 13 || parentType == 136) {
            return;
        }
        if (parentType == 10 || parentType == 8 || parentType == 9 || parentType == 14 || parentType == 154 || parentType == 15 || parentType == 21 || parentType == 164) {
            return;
        }
        String name = ast.getText();
        if (this.isClassField(name)) {
            this.log(ast, "require.this.variable", name);
        }
    }
}

