/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class HideUtilityClassConstructorCheck
extends Check {
    @Override
    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isUtilClass;
        if (this.isAbstract(ast)) {
            return;
        }
        DetailAST objBlock = ast.findFirstToken(6);
        boolean hasStaticModifier = this.isStatic(ast);
        boolean hasMethodOrField = false;
        boolean hasNonStaticMethodOrField = false;
        boolean hasNonPrivateStaticMethodOrField = false;
        boolean hasDefaultCtor = true;
        boolean hasPublicCtor = false;
        for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST modifiers;
            int type = child.getType();
            if (type == 9 || type == 10) {
                hasMethodOrField = true;
                modifiers = child.findFirstToken(5);
                boolean isStatic = modifiers.branchContains(64);
                boolean isPrivate = modifiers.branchContains(61);
                if (!isStatic && !isPrivate) {
                    hasNonStaticMethodOrField = true;
                }
                if (isStatic && !isPrivate) {
                    hasNonPrivateStaticMethodOrField = true;
                }
            }
            if (type != 8) continue;
            hasDefaultCtor = false;
            modifiers = child.findFirstToken(5);
            if (modifiers.branchContains(61) || modifiers.branchContains(63)) continue;
            hasPublicCtor = true;
        }
        boolean hasAccessibleCtor = hasDefaultCtor || hasPublicCtor;
        boolean extendsJLO = ast.findFirstToken(18) == null;
        boolean bl = isUtilClass = extendsJLO && hasMethodOrField && !hasNonStaticMethodOrField && hasNonPrivateStaticMethodOrField;
        if (isUtilClass && hasAccessibleCtor && !hasStaticModifier) {
            this.log(ast.getLineNo(), ast.getColumnNo(), "hide.utility.class", new Object[0]);
        }
    }

    private boolean isAbstract(DetailAST ast) {
        return ast.findFirstToken(5).branchContains(40);
    }

    private boolean isStatic(DetailAST ast) {
        return ast.findFirstToken(5).branchContains(64);
    }
}

