/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class WriteTagCheck
extends Check {
    private Pattern tagRE;
    private Pattern tagFormatRE;
    private String tag;
    private String tagFormat;
    private SeverityLevel tagSeverityLevel = SeverityLevel.INFO;

    public void setTag(String tag) throws ConversionException {
        try {
            this.tag = tag;
            this.tagRE = Utils.getPattern(tag + "\\s*(.*$)");
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + tag, (Throwable)e);
        }
    }

    public void setTagFormat(String format) throws ConversionException {
        try {
            this.tagFormat = format;
            this.tagFormatRE = Utils.getPattern(format);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + format, (Throwable)e);
        }
    }

    public final void setTagSeverity(String severity) {
        this.tagSeverityLevel = SeverityLevel.getInstance(severity);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157, 9, 8, 155, 161};
    }

    @Override
    public void visitToken(DetailAST ast) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock cmt = contents.getJavadocBefore(lineNo = ast.getLineNo());
        if (cmt == null) {
            this.log(lineNo, "type.missingTag", this.tag);
        } else {
            this.checkTag(lineNo, cmt.getText(), this.tag, this.tagRE, this.tagFormatRE, this.tagFormat);
        }
    }

    private void checkTag(int lineNo, String[] comment, String tag, Pattern tagRE, Pattern formatRE, String format) {
        if (tagRE == null) {
            return;
        }
        int tagCount = 0;
        for (int i = 0; i < comment.length; ++i) {
            String s = comment[i];
            Matcher matcher = tagRE.matcher(s);
            if (!matcher.find()) continue;
            ++tagCount;
            int contentStart = matcher.start(1);
            String content = s.substring(contentStart);
            if (formatRE != null && !formatRE.matcher(content).find()) {
                this.log(lineNo + i - comment.length, "type.tagFormat", tag, format);
                continue;
            }
            this.logTag(lineNo + i - comment.length, tag, content);
        }
        if (tagCount == 0) {
            this.log(lineNo, "type.missingTag", tag);
        }
    }

    protected final void logTag(int line, String tag, String tagValue) {
        String originalSeverity = this.getSeverity();
        this.setSeverity(this.tagSeverityLevel.getName());
        this.log(line, "javadoc.writeTag", tag, tagValue);
        this.setSeverity(originalSeverity);
    }
}

