/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;

public final class BooleanExpressionComplexityCheck
extends Check {
    private static final int DEFAULT_MAX = 3;
    private final FastStack<Context> contextStack = FastStack.newInstance();
    private int max;
    private Context context;

    public BooleanExpressionComplexityCheck() {
        this.setMax(3);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 28, 111, 114, 110, 112, 113};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{8, 9, 28};
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: {
                this.visitMethodDef(ast);
                break;
            }
            case 28: {
                this.visitExpr();
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                this.context.visitBooleanOperator();
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: {
                this.leaveMethodDef();
                break;
            }
            case 28: {
                this.leaveExpr(ast);
                break;
            }
        }
    }

    private void visitMethodDef(DetailAST ast) {
        this.contextStack.push(this.context);
        this.context = new Context(!CheckUtils.isEqualsMethod(ast));
    }

    private void leaveMethodDef() {
        this.context = this.contextStack.pop();
    }

    private void visitExpr() {
        this.contextStack.push(this.context);
        this.context = new Context(this.context == null || this.context.isChecking());
    }

    private void leaveExpr(DetailAST ast) {
        this.context.checkCount(ast);
        this.context = this.contextStack.pop();
    }

    private class Context {
        private final boolean checking;
        private int count;

        public Context(boolean checking) {
            this.checking = checking;
            this.count = 0;
        }

        public boolean isChecking() {
            return this.checking;
        }

        public void visitBooleanOperator() {
            ++this.count;
        }

        public void checkCount(DetailAST ast) {
            if (this.checking && this.count > BooleanExpressionComplexityCheck.this.getMax()) {
                DetailAST parentAST = ast.getParent();
                BooleanExpressionComplexityCheck.this.log(parentAST.getLineNo(), parentAST.getColumnNo(), "booleanExpressionComplexity", this.count, BooleanExpressionComplexityCheck.this.getMax());
            }
        }
    }
}

