/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.checks.regexp.DetectorOptions;
import java.util.regex.Matcher;

class MultilineDetector {
    private final DetectorOptions options;
    private int currentMatches;
    private Matcher matcher;
    private FileText text;

    public MultilineDetector(DetectorOptions options) {
        this.options = options;
    }

    public void processLines(FileText text) {
        this.text = text;
        this.resetState();
        this.matcher = this.options.getPattern().matcher(text.getFullText());
        this.findMatch();
        this.finish();
    }

    private void findMatch() {
        boolean foundMatch = this.matcher.find();
        if (!foundMatch) {
            return;
        }
        LineColumn start = this.text.lineColumn(this.matcher.start());
        LineColumn end = this.text.lineColumn(this.matcher.end());
        if (!this.options.getSuppressor().shouldSuppress(start.getLine(), start.getColumn(), end.getLine(), end.getColumn())) {
            ++this.currentMatches;
            if (this.currentMatches > this.options.getMaximum()) {
                if ("".equals(this.options.getMessage())) {
                    this.options.getReporter().log(start.getLine(), "regexp.exceeded", this.matcher.pattern().toString());
                } else {
                    this.options.getReporter().log(start.getLine(), this.options.getMessage(), new Object[0]);
                }
            }
        }
        this.findMatch();
    }

    private void finish() {
        if (this.currentMatches < this.options.getMinimum()) {
            if ("".equals(this.options.getMessage())) {
                this.options.getReporter().log(0, "regexp.minimum", this.options.getMinimum(), this.options.getFormat());
            } else {
                this.options.getReporter().log(0, this.options.getMessage(), new Object[0]);
            }
        }
    }

    private void resetState() {
        this.currentMatches = 0;
    }
}

