/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class OuterTypeNumberCheck
extends Check {
    private int max = 1;
    private int currentDepth;
    private int outerNum;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 157};
    }

    @Override
    public void beginTree(DetailAST ast) {
        this.currentDepth = 0;
        this.outerNum = 0;
    }

    @Override
    public void finishTree(DetailAST ast) {
        if (this.max < this.outerNum) {
            this.log(ast, "maxOuterTypes", this.outerNum, this.max);
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (0 == this.currentDepth) {
            ++this.outerNum;
        }
        ++this.currentDepth;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        --this.currentDepth;
    }

    public void setMax(int to) {
        this.max = to;
    }
}

