/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ParameterNumberCheck
extends Check {
    private static final String OVERRIDE = "Override";
    private static final String CANONICAL_OVERRIDE = "java.lang.Override";
    private static final int DEFAULT_MAX_PARAMETERS = 7;
    private int max = 7;
    private boolean ignoreOverriddenMethods;

    public void setMax(int max) {
        this.max = max;
    }

    public void setIgnoreOverriddenMethods(boolean ignoreOverriddenMethods) {
        this.ignoreOverriddenMethods = ignoreOverriddenMethods;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST params = ast.findFirstToken(20);
        int count = params.getChildCount(21);
        if (count > this.max && !this.ignoreNumberOfParameters(ast)) {
            DetailAST name = ast.findFirstToken(58);
            this.log(name.getLineNo(), name.getColumnNo(), "maxParam", this.max, count);
        }
    }

    private boolean ignoreNumberOfParameters(DetailAST ast) {
        return this.ignoreOverriddenMethods && (AnnotationUtility.containsAnnotation(ast, OVERRIDE) || AnnotationUtility.containsAnnotation(ast, CANONICAL_OVERRIDE));
    }
}

