/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

public class EmptyForIteratorPadCheck
extends AbstractOptionCheck<PadOption> {
    public EmptyForIteratorPadCheck() {
        super(PadOption.NOSPACE, PadOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{37};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getChildCount() == 0) {
            DetailAST semi = ast.getPreviousSibling();
            String line = this.getLines()[semi.getLineNo() - 1];
            int after = semi.getColumnNo() + 1;
            if (after < line.length()) {
                if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, "ws.followed", ";");
                } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, "ws.notFollowed", ";");
                }
            }
        }
    }
}

