/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class JavadocTypeCheck
extends Check {
    public static final String JAVADOC_MISSING = "javadoc.missing";
    public static final String UNKNOWN_TAG = "javadoc.unknownTag";
    public static final String TAG_FORMAT = "type.tagFormat";
    public static final String MISSING_TAG = "type.missingTag";
    public static final String UNUSED_TAG = "javadoc.unusedTag";
    public static final String UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern authorFormatPattern;
    private Pattern versionFormatPattern;
    private String authorFormat;
    private String versionFormat;
    private boolean allowMissingParamTags;
    private boolean allowUnknownTags;

    public void setScope(String from) {
        this.scope = Scope.getInstance(from);
    }

    public void setExcludeScope(String scope) {
        this.excludeScope = Scope.getInstance(scope);
    }

    public void setAuthorFormat(String format) throws ConversionException {
        try {
            this.authorFormat = format;
            this.authorFormatPattern = Utils.getPattern(format);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + format, (Throwable)e);
        }
    }

    public void setVersionFormat(String format) throws ConversionException {
        try {
            this.versionFormat = format;
            this.versionFormatPattern = Utils.getPattern(format);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + format, (Throwable)e);
        }
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowUnknownTags(boolean flag) {
        this.allowUnknownTags = flag;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{15, 14, 154, 157};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 154, 157};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.shouldCheck(ast)) {
            int lineNo;
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(lineNo = ast.getLineNo());
            if (cmt == null) {
                this.log(lineNo, JAVADOC_MISSING, new Object[0]);
            } else if (ScopeUtils.isOuterMostType(ast)) {
                List<JavadocTag> tags = this.getJavadocTags(cmt);
                this.checkTag(lineNo, tags, JavadocTagInfo.AUTHOR.getName(), this.authorFormatPattern, this.authorFormat);
                this.checkTag(lineNo, tags, JavadocTagInfo.VERSION.getName(), this.versionFormatPattern, this.versionFormat);
                List<String> typeParamNames = CheckUtils.getTypeParameterNames(ast);
                if (!this.allowMissingParamTags) {
                    for (String string : typeParamNames) {
                        this.checkTypeParamTag(lineNo, tags, string);
                    }
                }
                this.checkUnusedTypeParamTags(tags, typeParamNames);
            }
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        DetailAST mods = ast.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        Scope scope = ScopeUtils.inInterfaceOrAnnotationBlock(ast) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope(ast);
        return scope.isIn(this.scope) && (surroundingScope == null || surroundingScope.isIn(this.scope)) && (this.excludeScope == null || !scope.isIn(this.excludeScope) || surroundingScope != null && !surroundingScope.isIn(this.excludeScope));
    }

    private List<JavadocTag> getJavadocTags(TextBlock cmt) {
        JavadocTags tags = JavadocUtils.getJavadocTags(cmt, JavadocUtils.JavadocTagType.BLOCK);
        if (!this.allowUnknownTags) {
            for (InvalidJavadocTag tag : tags.getInvalidTags()) {
                this.log(tag.getLine(), tag.getCol(), UNKNOWN_TAG, tag.getName());
            }
        }
        return tags.getValidTags();
    }

    private void checkTag(int lineNo, List<JavadocTag> tags, String tagName, Pattern formatPattern, String format) {
        if (formatPattern == null) {
            return;
        }
        int tagCount = 0;
        for (int i = tags.size() - 1; i >= 0; --i) {
            JavadocTag tag = tags.get(i);
            if (!tag.getTagName().equals(tagName)) continue;
            ++tagCount;
            if (formatPattern.matcher(tag.getArg1()).find()) continue;
            this.log(lineNo, TAG_FORMAT, "@" + tagName, format);
        }
        if (tagCount == 0) {
            this.log(lineNo, MISSING_TAG, "@" + tagName);
        }
    }

    private void checkTypeParamTag(int lineNo, List<JavadocTag> tags, String typeParamName) {
        boolean found = false;
        for (int i = tags.size() - 1; i >= 0; --i) {
            JavadocTag tag = tags.get(i);
            if (!tag.isParamTag() || tag.getArg1() == null || tag.getArg1().indexOf("<" + typeParamName + ">") != 0) continue;
            found = true;
        }
        if (!found) {
            this.log(lineNo, MISSING_TAG, JavadocTagInfo.PARAM.getText() + " <" + typeParamName + ">");
        }
    }

    private void checkUnusedTypeParamTags(List<JavadocTag> tags, List<String> typeParamNames) {
        Pattern pattern = Utils.getPattern("\\s*<([^>]+)>.*");
        for (int i = tags.size() - 1; i >= 0; --i) {
            JavadocTag tag = tags.get(i);
            if (!tag.isParamTag()) continue;
            if (tag.getArg1() != null) {
                Matcher matcher = pattern.matcher(tag.getArg1());
                String typeParamName = null;
                if (matcher.matches()) {
                    typeParamName = matcher.group(1).trim();
                    if (typeParamNames.contains(typeParamName)) continue;
                    this.log(tag.getLineNo(), tag.getColumnNo(), UNUSED_TAG, JavadocTagInfo.PARAM.getText(), "<" + typeParamName + ">");
                    continue;
                }
                this.log(tag.getLineNo(), tag.getColumnNo(), UNUSED_TAG_GENERAL, new Object[0]);
                continue;
            }
            this.log(tag.getLineNo(), tag.getColumnNo(), UNUSED_TAG_GENERAL, new Object[0]);
        }
    }
}

