/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.SeverityLevelCounter;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Checker
extends AutomaticBean
implements MessageDispatcher {
    private final SeverityLevelCounter counter = new SeverityLevelCounter(SeverityLevel.ERROR);
    private final List<AuditListener> listeners = Lists.newArrayList();
    private final List<FileSetCheck> fileSetChecks = Lists.newArrayList();
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private String basedir;
    private String localeCountry = Locale.getDefault().getCountry();
    private String localeLanguage = Locale.getDefault().getLanguage();
    private ModuleFactory moduleFactory;
    private ClassLoader moduleClassLoader;
    private Context childContext;
    private final FilterSet filters = new FilterSet();
    private String[] fileExtensions = new String[0];
    private SeverityLevel severityLevel = SeverityLevel.ERROR;
    private String charset = System.getProperty("file.encoding", "UTF-8");

    public Checker() throws CheckstyleException {
        this.addListener(this.counter);
    }

    @Override
    public void finishLocalSetup() throws CheckstyleException {
        Locale locale = new Locale(this.localeLanguage, this.localeCountry);
        LocalizedMessage.setLocale(locale);
        if (this.moduleFactory == null) {
            if (this.moduleClassLoader == null) {
                throw new CheckstyleException("if no custom moduleFactory is set, moduleClassLoader must be specified");
            }
            Set<String> packageNames = PackageNamesLoader.getPackageNames(this.moduleClassLoader);
            this.moduleFactory = new PackageObjectFactory(packageNames, this.moduleClassLoader);
        }
        DefaultContext context = new DefaultContext();
        context.add("charset", this.charset);
        context.add("classLoader", this.loader);
        context.add("moduleFactory", this.moduleFactory);
        context.add("severity", this.severityLevel.getName());
        context.add("basedir", this.basedir);
        this.childContext = context;
    }

    @Override
    protected void setupChild(Configuration childConf) throws CheckstyleException {
        block6: {
            String name = childConf.getName();
            try {
                Object child = this.moduleFactory.createModule(name);
                if (child instanceof AutomaticBean) {
                    AutomaticBean bean = (AutomaticBean)child;
                    bean.contextualize(this.childContext);
                    bean.configure(childConf);
                }
                if (child instanceof FileSetCheck) {
                    FileSetCheck fsc = (FileSetCheck)child;
                    this.addFileSetCheck(fsc);
                    break block6;
                }
                if (child instanceof Filter) {
                    Filter filter = (Filter)child;
                    this.addFilter(filter);
                    break block6;
                }
                if (child instanceof AuditListener) {
                    AuditListener listener = (AuditListener)child;
                    this.addListener(listener);
                    break block6;
                }
                throw new CheckstyleException(name + " is not allowed as a child in Checker");
            }
            catch (Exception ex) {
                throw new CheckstyleException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
            }
        }
    }

    public void addFileSetCheck(FileSetCheck fileSetCheck) {
        fileSetCheck.setMessageDispatcher(this);
        this.fileSetChecks.add(fileSetCheck);
    }

    public void addFilter(Filter filter) {
        this.filters.addFilter(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.removeFilter(filter);
    }

    public void destroy() {
        this.listeners.clear();
        this.filters.clear();
    }

    public final void addListener(AuditListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AuditListener listener) {
        this.listeners.remove(listener);
    }

    public int process(List<File> files) {
        this.fireAuditStarted();
        for (FileSetCheck fsc : this.fileSetChecks) {
            fsc.beginProcessing(this.charset);
        }
        for (File f : files) {
            if (!com.puppycrawl.tools.checkstyle.Utils.fileExtensionMatches(f, this.fileExtensions)) continue;
            String fileName = f.getAbsolutePath();
            this.fireFileStarted(fileName);
            TreeSet fileMessages = Sets.newTreeSet();
            try {
                FileText theText = new FileText(f.getAbsoluteFile(), this.charset);
                for (FileSetCheck fsc : this.fileSetChecks) {
                    fileMessages.addAll(fsc.process(f, theText));
                }
            }
            catch (FileNotFoundException fnfe) {
                Utils.getExceptionLogger().debug((Object)"FileNotFoundException occured.", (Throwable)fnfe);
                fileMessages.add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.fileNotFound", null, null, this.getClass(), null));
            }
            catch (IOException ioe) {
                Utils.getExceptionLogger().debug((Object)"IOException occured.", (Throwable)ioe);
                fileMessages.add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{ioe.getMessage()}, null, this.getClass(), null));
            }
            this.fireErrors(fileName, fileMessages);
            this.fireFileFinished(fileName);
        }
        for (FileSetCheck fsc : this.fileSetChecks) {
            fsc.finishProcessing();
            fsc.destroy();
        }
        int errorCount = this.counter.getCount();
        this.fireAuditFinished();
        return errorCount;
    }

    private String getStrippedFileName(String fileName) {
        return Utils.getStrippedFileName(this.basedir, fileName);
    }

    public void setBasedir(String basedir) {
        this.basedir = this.normalize(basedir);
    }

    public String normalize(String normalizingPath) {
        int i;
        if (normalizingPath == null) {
            return normalizingPath;
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean onNetWare = osName.indexOf("netware") > -1;
        String path = normalizingPath.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int colon = path.indexOf(":");
        if (!onNetWare) {
            if (!(path.startsWith(File.separator) || path.length() >= 2 && Character.isLetter(path.charAt(0)) && colon == 1)) {
                String msg = path + " is not an absolute path";
                throw new IllegalArgumentException(msg);
            }
        } else if (!path.startsWith(File.separator) && colon == -1) {
            String msg = path + " is not an absolute path";
            throw new IllegalArgumentException(msg);
        }
        boolean dosWithDrive = false;
        String root = null;
        if (!onNetWare && path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || onNetWare && colon > -1) {
            dosWithDrive = true;
            char[] ca = path.replace('/', '\\').toCharArray();
            StringBuilder sbRoot = new StringBuilder();
            for (int i2 = 0; i2 < colon; ++i2) {
                sbRoot.append(Character.toUpperCase(ca[i2]));
            }
            sbRoot.append(':');
            if (colon + 1 < path.length()) {
                sbRoot.append(File.separatorChar);
            }
            root = sbRoot.toString();
            StringBuilder sbPath = new StringBuilder();
            for (i = colon + 1; i < ca.length; ++i) {
                if (ca[i] == '\\' && (ca[i] != '\\' || ca[i - 1] == '\\')) continue;
                sbPath.append(ca[i]);
            }
            path = sbPath.toString().replace('\\', File.separatorChar);
        } else if (path.length() == 1) {
            root = File.separator;
            path = "";
        } else if (path.charAt(1) == File.separatorChar) {
            root = File.separator + File.separator;
            path = path.substring(2);
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        FastStack s = FastStack.newInstance();
        s.push(root);
        StringTokenizer tok = new StringTokenizer(path, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    throw new IllegalArgumentException("Cannot resolve path " + path);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append((String)s.peek(i));
        }
        path = sb.toString();
        if (dosWithDrive) {
            path = path.replace('/', '\\');
        }
        return path;
    }

    public final String getBasedir() {
        return this.basedir;
    }

    protected void fireAuditStarted() {
        AuditEvent evt = new AuditEvent(this);
        for (AuditListener listener : this.listeners) {
            listener.auditStarted(evt);
        }
    }

    protected void fireAuditFinished() {
        AuditEvent evt = new AuditEvent(this);
        for (AuditListener listener : this.listeners) {
            listener.auditFinished(evt);
        }
    }

    @Override
    public void fireFileStarted(String fileName) {
        String stripped = this.getStrippedFileName(fileName);
        AuditEvent evt = new AuditEvent(this, stripped);
        for (AuditListener listener : this.listeners) {
            listener.fileStarted(evt);
        }
    }

    @Override
    public void fireFileFinished(String fileName) {
        String stripped = this.getStrippedFileName(fileName);
        AuditEvent evt = new AuditEvent(this, stripped);
        for (AuditListener listener : this.listeners) {
            listener.fileFinished(evt);
        }
    }

    @Override
    public void fireErrors(String fileName, SortedSet<LocalizedMessage> errors) {
        String stripped = this.getStrippedFileName(fileName);
        for (LocalizedMessage element : errors) {
            AuditEvent evt = new AuditEvent(this, stripped, element);
            if (!this.filters.accept(evt)) continue;
            for (AuditListener listener : this.listeners) {
                listener.addError(evt);
            }
        }
    }

    public final void setFileExtensions(String[] extensions) {
        if (extensions == null) {
            this.fileExtensions = null;
            return;
        }
        this.fileExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            this.fileExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
        }
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    public void setLocaleCountry(String localeCountry) {
        this.localeCountry = localeCountry;
    }

    public void setLocaleLanguage(String localeLanguage) {
        this.localeLanguage = localeLanguage;
    }

    public final void setSeverity(String severity) {
        this.severityLevel = SeverityLevel.getInstance(severity);
    }

    public final void setClassloader(ClassLoader loader) {
        this.loader = loader;
    }

    public final void setModuleClassLoader(ClassLoader moduleClassLoader) {
        this.moduleClassLoader = moduleClassLoader;
    }

    public void setCharset(String charset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(charset)) {
            String message = "unsupported charset: '" + charset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.charset = charset;
    }
}

