/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultConfiguration
implements Configuration {
    private static final long serialVersionUID = 1157875385356127169L;
    private final String name;
    private final List<Configuration> children = Lists.newArrayList();
    private final Map<String, String> attributeMap = Maps.newHashMap();
    private final Map<String, String> messages = Maps.newHashMap();

    public DefaultConfiguration(String name) {
        this.name = name;
    }

    @Override
    public String[] getAttributeNames() {
        Set<String> keySet = this.attributeMap.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    public String getAttribute(String name) throws CheckstyleException {
        if (!this.attributeMap.containsKey(name)) {
            throw new CheckstyleException("missing key '" + name + "' in " + this.getName());
        }
        return this.attributeMap.get(name);
    }

    @Override
    public Configuration[] getChildren() {
        return this.children.toArray(new Configuration[this.children.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addChild(Configuration configuration) {
        this.children.add(configuration);
    }

    public void removeChild(Configuration configuration) {
        this.children.remove(configuration);
    }

    public void addAttribute(String name, String value) {
        String current = this.attributeMap.put(name, value);
        if (null == current) {
            this.attributeMap.put(name, value);
        } else {
            this.attributeMap.put(name, current + "," + value);
        }
    }

    public void addMessage(String key, String value) {
        this.messages.put(key, value);
    }

    @Override
    public ImmutableMap<String, String> getMessages() {
        return ImmutableMap.copyOf(this.messages);
    }
}

