/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NeedBracesCheck
extends Check {
    private boolean allowSingleLineIf;
    public static final String MSG_KEY_NEED_BRACES = "needBraces";

    public void setAllowSingleLineIf(boolean allowSingleLineIf) {
        this.allowSingleLineIf = allowSingleLineIf;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{85, 92, 91, 83, 84};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{85, 92, 91, 83, 84, 93, 94, 181};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST slistAST = ast.findFirstToken(7);
        boolean isElseIf = false;
        if (ast.getType() == 92 && ast.findFirstToken(83) != null) {
            isElseIf = true;
        }
        boolean skipStatement = false;
        if (ast.getType() == 83) {
            skipStatement = this.isSkipIfBlock(ast);
        }
        if (slistAST == null && !isElseIf && !skipStatement) {
            this.log(ast.getLineNo(), MSG_KEY_NEED_BRACES, ast.getText());
        }
    }

    private boolean isSkipIfBlock(DetailAST literalIf) {
        return this.allowSingleLineIf && NeedBracesCheck.isSingleLineIf(literalIf);
    }

    private static boolean isSingleLineIf(DetailAST literalIf) {
        boolean result = false;
        DetailAST ifBlock = literalIf.getLastChild();
        DetailAST lastElementInIfBlock = ifBlock.getLastChild();
        if (lastElementInIfBlock != null && lastElementInIfBlock.getFirstChild() == null && literalIf.getLineNo() == lastElementInIfBlock.getLineNo()) {
            result = true;
        }
        return result;
    }
}

