/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.Set;
import java.util.StringTokenizer;

public class IllegalInstantiationCheck
extends Check {
    public static final String MSG_KEY = "instantiation.avoid";
    private final Set<String> illegalClasses = Sets.newHashSet();
    private String pkgName;
    private final Set<FullIdent> imports = Sets.newHashSet();
    private final Set<String> classNames = Sets.newHashSet();
    private final Set<DetailAST> instantiations = Sets.newHashSet();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 136, 16, 14};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[0];
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 136, 16};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        super.beginTree(rootAST);
        this.pkgName = null;
        this.imports.clear();
        this.instantiations.clear();
        this.classNames.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 136: {
                this.processLiteralNew(ast);
                break;
            }
            case 16: {
                this.processPackageDef(ast);
                break;
            }
            case 30: {
                this.processImport(ast);
                break;
            }
            case 14: {
                this.processClassDef(ast);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)ast));
            }
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        for (DetailAST literalNewAST : this.instantiations) {
            this.postprocessLiteralNew(literalNewAST);
        }
    }

    private void processClassDef(DetailAST ast) {
        DetailAST identToken = ast.findFirstToken(58);
        String className = identToken.getText();
        this.classNames.add(className);
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        if (name != null) {
            this.imports.add(name);
        }
    }

    private void processPackageDef(DetailAST ast) {
        DetailAST packageNameAST = ast.getLastChild().getPreviousSibling();
        FullIdent packageIdent = FullIdent.createFullIdent(packageNameAST);
        this.pkgName = packageIdent.getText();
    }

    private void processLiteralNew(DetailAST ast) {
        if (ast.getParent().getType() == 180) {
            return;
        }
        this.instantiations.add(ast);
    }

    private void postprocessLiteralNew(DetailAST ast) {
        DetailAST typeNameAST = ast.getFirstChild();
        DetailAST nameSibling = typeNameAST.getNextSibling();
        if (nameSibling != null && nameSibling.getType() == 17) {
            return;
        }
        FullIdent typeIdent = FullIdent.createFullIdent(typeNameAST);
        String typeName = typeIdent.getText();
        int lineNo = ast.getLineNo();
        int colNo = ast.getColumnNo();
        String fqClassName = this.getIllegalInstantiation(typeName);
        if (fqClassName != null) {
            this.log(lineNo, colNo, MSG_KEY, fqClassName);
        }
    }

    private String getIllegalInstantiation(String className) {
        String javlang = "java.lang.";
        if (this.illegalClasses.contains(className)) {
            return className;
        }
        int clsNameLen = className.length();
        int pkgNameLen = this.pkgName == null ? 0 : this.pkgName.length();
        for (String illegal : this.illegalClasses) {
            int illegalLen = illegal.length();
            if (illegalLen - "java.lang.".length() == clsNameLen && illegal.endsWith(className) && illegal.startsWith("java.lang.")) {
                boolean isSameFile = this.classNames.contains(className);
                boolean isSamePackage = false;
                try {
                    ClassLoader classLoader = this.getClassLoader();
                    if (classLoader != null) {
                        String fqName = this.pkgName + "." + className;
                        classLoader.loadClass(fqName);
                        isSamePackage = true;
                    }
                }
                catch (ClassNotFoundException ex) {
                    isSamePackage = false;
                }
                if (!isSameFile && !isSamePackage) {
                    return illegal;
                }
            }
            if (this.pkgName != null && clsNameLen == illegalLen - pkgNameLen - 1 && illegal.charAt(pkgNameLen) == '.' && illegal.endsWith(className) && illegal.startsWith(this.pkgName)) {
                return illegal;
            }
            for (FullIdent importLineText : this.imports) {
                String importArg = importLineText.getText();
                if (importArg.endsWith(".*")) {
                    String fqClass = importArg.substring(0, importArg.length() - 1) + className;
                    if (!this.illegalClasses.contains(fqClass)) continue;
                    return fqClass;
                }
                if (!Utils.baseClassname(importArg).equals(className) || !this.illegalClasses.contains(importArg)) continue;
                return importArg;
            }
        }
        return null;
    }

    public void setClasses(String classNames) {
        this.illegalClasses.clear();
        StringTokenizer tok = new StringTokenizer(classNames, ",");
        while (tok.hasMoreTokens()) {
            this.illegalClasses.add(tok.nextToken());
        }
    }
}

