/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.FileContentsHolder;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class SuppressionCommentFilter
extends AutomaticBean
implements Filter {
    private static final String DEFAULT_OFF_FORMAT = "CHECKSTYLE\\:OFF";
    private static final String DEFAULT_ON_FORMAT = "CHECKSTYLE\\:ON";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private boolean checkC = true;
    private boolean checkCPP = true;
    private Pattern offRegexp;
    private Pattern onRegexp;
    private String checkFormat;
    private Pattern checkRegexp;
    private String messageFormat;
    private final List<Tag> tags = Lists.newArrayList();
    private WeakReference<FileContents> fileContentsReference = new WeakReference<Object>(null);

    public SuppressionCommentFilter() {
        this.setOnCommentFormat(DEFAULT_ON_FORMAT);
        this.setOffCommentFormat(DEFAULT_OFF_FORMAT);
        this.setCheckFormat(DEFAULT_CHECK_FORMAT);
    }

    public void setOffCommentFormat(String format) throws ConversionException {
        this.offRegexp = Utils.createPattern(format);
    }

    public void setOnCommentFormat(String format) throws ConversionException {
        this.onRegexp = Utils.createPattern(format);
    }

    public FileContents getFileContents() {
        return (FileContents)this.fileContentsReference.get();
    }

    public void setFileContents(FileContents fileContents) {
        this.fileContentsReference = new WeakReference<FileContents>(fileContents);
    }

    public void setCheckFormat(String format) throws ConversionException {
        this.checkRegexp = Utils.createPattern(format);
        this.checkFormat = format;
    }

    public void setMessageFormat(String format) throws ConversionException {
        if (!Utils.isPatternValid(format)) {
            throw new ConversionException("Unable to parse format: " + format);
        }
        this.messageFormat = format;
    }

    public void setCheckCPP(boolean checkCPP) {
        this.checkCPP = checkCPP;
    }

    public void setCheckC(boolean checkC) {
        this.checkC = checkC;
    }

    @Override
    public boolean accept(AuditEvent event) {
        Tag matchTag;
        if (event.getLocalizedMessage() == null) {
            return true;
        }
        FileContents currentContents = FileContentsHolder.getContents();
        if (currentContents == null) {
            return true;
        }
        if (this.getFileContents() != currentContents) {
            this.setFileContents(currentContents);
            this.tagSuppressions();
        }
        return (matchTag = this.findNearestMatch(event)) == null || matchTag.isOn();
    }

    private Tag findNearestMatch(AuditEvent event) {
        Tag result = null;
        for (Tag tag : this.tags) {
            if (tag.getLine() > event.getLine() || tag.getLine() == event.getLine() && tag.getColumn() > event.getColumn()) break;
            if (!tag.isMatch(event)) continue;
            result = tag;
        }
        return result;
    }

    private void tagSuppressions() {
        this.tags.clear();
        FileContents contents = this.getFileContents();
        if (this.checkCPP) {
            this.tagSuppressions((Collection<TextBlock>)contents.getCppComments().values());
        }
        if (this.checkC) {
            ImmutableCollection cCoonts = contents.getCComments().values();
            for (List eleont : cCoonts) {
                this.tagSuppressions(eleont);
            }
        }
        Collections.sort(this.tags);
    }

    private void tagSuppressions(Collection<TextBlock> comments) {
        for (TextBlock comment : comments) {
            int startLineNo = comment.getStartLineNo();
            String[] text = comment.getText();
            this.tagCommentLine(text[0], startLineNo, comment.getStartColNo());
            for (int i = 1; i < text.length; ++i) {
                this.tagCommentLine(text[i], startLineNo + i, 0);
            }
        }
    }

    private void tagCommentLine(String text, int line, int column) {
        Matcher offMatcher = this.offRegexp.matcher(text);
        if (offMatcher.find()) {
            this.addTag(offMatcher.group(0), line, column, false);
        } else {
            Matcher onMatcher = this.onRegexp.matcher(text);
            if (onMatcher.find()) {
                this.addTag(onMatcher.group(0), line, column, true);
            }
        }
    }

    private void addTag(String text, int line, int column, boolean on) {
        Tag tag = new Tag(line, column, text, on);
        this.tags.add(tag);
    }

    public class Tag
    implements Comparable<Tag> {
        private final String text;
        private final int line;
        private final int column;
        private final boolean on;
        private Pattern tagCheckRegexp;
        private Pattern tagMessageRegexp;

        public Tag(int line, int column, String text, boolean on) throws ConversionException {
            this.line = line;
            this.column = column;
            this.text = text;
            this.on = on;
            this.tagCheckRegexp = SuppressionCommentFilter.this.checkRegexp;
            String format = "";
            try {
                if (on) {
                    format = this.expandFromCoont(text, SuppressionCommentFilter.this.checkFormat, SuppressionCommentFilter.this.onRegexp);
                    this.tagCheckRegexp = Pattern.compile(format);
                    if (SuppressionCommentFilter.this.messageFormat != null) {
                        format = this.expandFromCoont(text, SuppressionCommentFilter.this.messageFormat, SuppressionCommentFilter.this.onRegexp);
                        this.tagMessageRegexp = Pattern.compile(format);
                    }
                } else {
                    format = this.expandFromCoont(text, SuppressionCommentFilter.this.checkFormat, SuppressionCommentFilter.this.offRegexp);
                    this.tagCheckRegexp = Pattern.compile(format);
                    if (SuppressionCommentFilter.this.messageFormat != null) {
                        format = this.expandFromCoont(text, SuppressionCommentFilter.this.messageFormat, SuppressionCommentFilter.this.offRegexp);
                        this.tagMessageRegexp = Pattern.compile(format);
                    }
                }
            }
            catch (PatternSyntaxException e) {
                throw new ConversionException("unable to parse expanded comment " + format, (Throwable)e);
            }
        }

        public String getText() {
            return this.text;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean isOn() {
            return this.on;
        }

        @Override
        public int compareTo(Tag object) {
            if (this.line == object.line) {
                return this.column - object.column;
            }
            return this.line - object.line;
        }

        public boolean isMatch(AuditEvent event) {
            Matcher tagMatcher = this.tagCheckRegexp.matcher(event.getSourceName());
            if (tagMatcher.find()) {
                if (this.tagMessageRegexp != null) {
                    Matcher messageMatcher = this.tagMessageRegexp.matcher(event.getMessage());
                    return messageMatcher.find();
                }
                return true;
            }
            return false;
        }

        private String expandFromCoont(String comment, String string, Pattern regexp) {
            Matcher matcher = regexp.matcher(comment);
            if (!matcher.find()) {
                return string;
            }
            String result = string;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                result = result.replaceAll("\\$" + i, matcher.group(i));
            }
            return result;
        }

        public final String toString() {
            return "Tag[line=" + this.getLine() + "; col=" + this.getColumn() + "; on=" + this.isOn() + "; text='" + this.getText() + "']";
        }
    }
}

