/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.AbstractTypeAwareCheck;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavadocMethodCheck
extends AbstractTypeAwareCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    public static final String MSG_CLASS_INFO = "javadoc.classInfo";
    public static final String MSG_UNUSED_TAG_GENERAL = "javadoc.unusedTagGeneral";
    public static final String MSG_INVALID_INHERIT_DOC = "javadoc.invalidInheritDoc";
    public static final String MSG_UNUSED_TAG = "javadoc.unusedTag";
    public static final String MSG_EXCPECTED_TAG = "javadoc.expectedTag";
    public static final String MSG_RETURN_EXPECTED = "javadoc.return.expected";
    public static final String MSG_DUPLICATE_TAG = "javadoc.duplicateTag";
    private static final Pattern MATCH_JAVADOC_ARG = Utils.createPattern("@(throws|exception|param)\\s+(\\S+)\\s+\\S*");
    private static final Pattern MATCH_JAVADOC_ARG_MULTILINE_START = Utils.createPattern("@(throws|exception|param)\\s+(\\S+)\\s*$");
    private static final Pattern MATCH_JAVADOC_MULTILINE_CONT = Utils.createPattern("(\\*/|@|[^\\s\\*])");
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final Pattern MATCH_JAVADOC_NOARG = Utils.createPattern("@(return|see)\\s+\\S");
    private static final Pattern MATCH_JAVADOC_NOARG_MULTILINE_START = Utils.createPattern("@(return|see)\\s*$");
    private static final Pattern MATCH_JAVADOC_NOARG_CURLY = Utils.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    private static final int MAX_CHILDREN = 7;
    private static final int BODY_SIZE = 3;
    private static final int DEFAULT_MIN_LINE_COUNT = -1;
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private int minLineCount = -1;
    private boolean allowUndeclaredRTE;
    private boolean validateThrows;
    private boolean allowThrowsTagsForSubclasses;
    private boolean allowMissingParamTags;
    private boolean allowMissingThrowsTags;
    private boolean allowMissingReturnTag;
    private boolean allowMissingJavadoc;
    private boolean allowMissingPropertyJavadoc;
    private List<String> allowedAnnotations = Arrays.asList("Override");
    private Pattern ignoreMethodNamesRegex;

    public void setIgnoreMethodNamesRegex(String regex) {
        this.ignoreMethodNamesRegex = Utils.createPattern(regex);
    }

    public void setMinLineCount(int value) {
        this.minLineCount = value;
    }

    public void setValidateThrows(boolean value) {
        this.validateThrows = value;
    }

    public void setAllowedAnnotations(String userAnnotations) {
        ArrayList<String> annotations = new ArrayList<String>();
        Collections.addAll(annotations, userAnnotations.split(", "));
        this.allowedAnnotations = annotations;
    }

    public void setScope(String from) {
        this.scope = Scope.getInstance(from);
    }

    public void setExcludeScope(String scope) {
        this.excludeScope = Scope.getInstance(scope);
    }

    public void setAllowUndeclaredRTE(boolean flag) {
        this.allowUndeclaredRTE = flag;
    }

    public void setAllowThrowsTagsForSubclasses(boolean flag) {
        this.allowThrowsTagsForSubclasses = flag;
    }

    public void setAllowMissingParamTags(boolean flag) {
        this.allowMissingParamTags = flag;
    }

    public void setAllowMissingThrowsTags(boolean flag) {
        this.allowMissingThrowsTags = flag;
    }

    public void setAllowMissingReturnTag(boolean flag) {
        this.allowMissingReturnTag = flag;
    }

    public void setAllowMissingJavadoc(boolean flag) {
        this.allowMissingJavadoc = flag;
    }

    public void setAllowMissingPropertyJavadoc(boolean flag) {
        this.allowMissingPropertyJavadoc = flag;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{16, 30, 14, 154, 15, 9, 8, 161};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 161};
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    protected final void processAST(DetailAST ast) {
        if ((ast.getType() == 9 || ast.getType() == 8) && this.getMethodsNumberOfLine(ast) <= this.minLineCount || this.hasAllowedAnnotations(ast)) {
            return;
        }
        Scope theScope = this.calculateScope(ast);
        if (this.shouldCheck(ast, theScope)) {
            FileContents contents = this.getFileContents();
            TextBlock cmt = contents.getJavadocBefore(ast.getLineNo());
            if (cmt == null) {
                if (!this.isMissingJavadocAllowed(ast)) {
                    this.log(ast, MSG_JAVADOC_MISSING, new Object[0]);
                }
            } else {
                this.checkComment(ast, cmt);
            }
        }
    }

    private boolean hasAllowedAnnotations(DetailAST methodDef) {
        DetailAST modifiersNode = methodDef.findFirstToken(5);
        for (DetailAST annotationNode = modifiersNode.findFirstToken(159); annotationNode != null && annotationNode.getType() == 159; annotationNode = annotationNode.getNextSibling()) {
            DetailAST identNode = annotationNode.findFirstToken(58);
            if (identNode == null) {
                identNode = annotationNode.findFirstToken(59).findFirstToken(58);
            }
            if (!this.allowedAnnotations.contains(identNode.getText())) continue;
            return true;
        }
        return false;
    }

    private int getMethodsNumberOfLine(DetailAST methodDef) {
        DetailAST lcurly = methodDef.getLastChild();
        DetailAST rcurly = lcurly.getLastChild();
        int numberOfLines = lcurly.getFirstChild() == rcurly ? 1 : rcurly.getLineNo() - lcurly.getLineNo() - 1;
        return numberOfLines;
    }

    @Override
    protected final void logLoadError(AbstractTypeAwareCheck.Token ident) {
        this.logLoadErrorImpl(ident.getLineNo(), ident.getColumnNo(), MSG_CLASS_INFO, JavadocTagInfo.THROWS.getText(), ident.getText());
    }

    protected boolean isMissingJavadocAllowed(DetailAST ast) {
        return this.allowMissingJavadoc || this.allowMissingPropertyJavadoc && (this.isSetterMethod(ast) || this.isGetterMethod(ast)) || this.matchesSkipRegex(ast);
    }

    private boolean matchesSkipRegex(DetailAST methodDef) {
        DetailAST ident;
        String methodName;
        Matcher matcher;
        return this.ignoreMethodNamesRegex != null && (matcher = this.ignoreMethodNamesRegex.matcher(methodName = (ident = methodDef.findFirstToken(58)).getText())).matches();
    }

    private boolean shouldCheck(DetailAST ast, Scope scope) {
        Scope surroundingScope = ScopeUtils.getSurroundingScope(ast);
        return scope.isIn(this.scope) && surroundingScope.isIn(this.scope) && (this.excludeScope == null || !scope.isIn(this.excludeScope) || !surroundingScope.isIn(this.excludeScope));
    }

    private void checkComment(DetailAST ast, TextBlock comment) {
        List<JavadocTag> tags = this.getMethodTags(comment);
        if (this.hasShortCircuitTag(ast, tags)) {
            return;
        }
        Iterator<JavadocTag> it = tags.iterator();
        if (ast.getType() != 161) {
            boolean hasInheritDocTag;
            for (hasInheritDocTag = false; it.hasNext() && !hasInheritDocTag; hasInheritDocTag |= it.next().isInheritDocTag()) {
            }
            this.checkParamTags(tags, ast, !hasInheritDocTag);
            this.checkThrowsTags(tags, this.getThrows(ast), !hasInheritDocTag);
            if (this.isFunction(ast)) {
                this.checkReturnTag(tags, ast.getLineNo(), !hasInheritDocTag);
            }
        }
        for (JavadocTag jt : tags) {
            if (jt.isSeeOrInheritDocTag()) continue;
            this.log(jt.getLineNo(), MSG_UNUSED_TAG_GENERAL, new Object[0]);
        }
    }

    private boolean hasShortCircuitTag(DetailAST ast, List<JavadocTag> tags) {
        if (tags.size() != 1 || !tags.get(0).isInheritDocTag()) {
            return false;
        }
        if (!JavadocTagInfo.INHERIT_DOC.isValidOn(ast)) {
            this.log(ast, MSG_INVALID_INHERIT_DOC, new Object[0]);
        }
        return true;
    }

    private Scope calculateScope(DetailAST ast) {
        DetailAST mods = ast.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods(mods);
        return ScopeUtils.inInterfaceOrAnnotationBlock(ast) ? Scope.PUBLIC : declaredScope;
    }

    private List<JavadocTag> getMethodTags(TextBlock comment) {
        String[] lines = comment.getText();
        ArrayList tags = Lists.newArrayList();
        int currentLine = comment.getStartLineNo() - 1;
        for (int i = 0; i < lines.length; ++i) {
            ++currentLine;
            Matcher javadocArgMatcher = MATCH_JAVADOC_ARG.matcher(lines[i]);
            Matcher javadocNoargMatcher = MATCH_JAVADOC_NOARG.matcher(lines[i]);
            Matcher noargCurlyMatcher = MATCH_JAVADOC_NOARG_CURLY.matcher(lines[i]);
            Matcher argMultilineStart = MATCH_JAVADOC_ARG_MULTILINE_START.matcher(lines[i]);
            Matcher noargMultilineStart = MATCH_JAVADOC_NOARG_MULTILINE_START.matcher(lines[i]);
            if (javadocArgMatcher.find()) {
                int col = javadocArgMatcher.start(1) - 1;
                if (i == 0) {
                    col += comment.getStartColNo();
                }
                tags.add(new JavadocTag(currentLine, col, javadocArgMatcher.group(1), javadocArgMatcher.group(2)));
                continue;
            }
            if (javadocNoargMatcher.find()) {
                int col = javadocNoargMatcher.start(1) - 1;
                if (i == 0) {
                    col += comment.getStartColNo();
                }
                tags.add(new JavadocTag(currentLine, col, javadocNoargMatcher.group(1)));
                continue;
            }
            if (noargCurlyMatcher.find()) {
                int col = noargCurlyMatcher.start(1) - 1;
                if (i == 0) {
                    col += comment.getStartColNo();
                }
                tags.add(new JavadocTag(currentLine, col, noargCurlyMatcher.group(1)));
                continue;
            }
            if (argMultilineStart.find()) {
                String p1 = argMultilineStart.group(1);
                String p2 = argMultilineStart.group(2);
                int col = argMultilineStart.start(1) - 1;
                if (i == 0) {
                    col += comment.getStartColNo();
                }
                for (int remIndex = i + 1; remIndex < lines.length; ++remIndex) {
                    Matcher multilineCont = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[remIndex]);
                    if (!multilineCont.find()) continue;
                    remIndex = lines.length;
                    String lFin = multilineCont.group(1);
                    if (lFin.equals(NEXT_TAG) || lFin.equals(END_JAVADOC)) continue;
                    tags.add(new JavadocTag(currentLine, col, p1, p2));
                }
                continue;
            }
            if (!noargMultilineStart.find()) continue;
            String p1 = noargMultilineStart.group(1);
            int col = noargMultilineStart.start(1) - 1;
            if (i == 0) {
                col += comment.getStartColNo();
            }
            for (int remIndex = i + 1; remIndex < lines.length; ++remIndex) {
                Matcher multilineCont = MATCH_JAVADOC_MULTILINE_CONT.matcher(lines[remIndex]);
                if (!multilineCont.find()) continue;
                remIndex = lines.length;
                String lFin = multilineCont.group(1);
                if (lFin.equals(NEXT_TAG) || lFin.equals(END_JAVADOC)) continue;
                tags.add(new JavadocTag(currentLine, col, p1));
            }
        }
        return tags;
    }

    private List<DetailAST> getParameters(DetailAST ast) {
        DetailAST params = ast.findFirstToken(20);
        ArrayList retVal = Lists.newArrayList();
        for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            DetailAST ident = child.findFirstToken(58);
            retVal.add(ident);
        }
        return retVal;
    }

    private List<ExceptionInfo> getThrows(DetailAST ast) {
        ArrayList retVal = Lists.newArrayList();
        DetailAST throwsAST = ast.findFirstToken(81);
        if (throwsAST != null) {
            for (DetailAST child = throwsAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 58 && child.getType() != 59) continue;
                FullIdent fi = FullIdent.createFullIdent(child);
                ExceptionInfo ei = new ExceptionInfo(this.createClassInfo(new AbstractTypeAwareCheck.Token(fi), this.getCurrentClassName()));
                retVal.add(ei);
            }
        }
        return retVal;
    }

    private void checkParamTags(List<JavadocTag> tags, DetailAST parent, boolean reportExpectedTags) {
        List<DetailAST> params = this.getParameters(parent);
        List<DetailAST> typeParams = CheckUtils.getTypeParameters(parent);
        ListIterator<JavadocTag> tagIt = tags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            boolean found = false;
            Iterator<DetailAST> paramIt = params.iterator();
            while (paramIt.hasNext()) {
                DetailAST param = paramIt.next();
                if (!param.getText().equals(tag.getArg1())) continue;
                found = true;
                paramIt.remove();
                break;
            }
            if (tag.getArg1().startsWith("<") && tag.getArg1().endsWith(">")) {
                Iterator<DetailAST> typeParamsIt = typeParams.iterator();
                while (typeParamsIt.hasNext()) {
                    DetailAST typeParam = typeParamsIt.next();
                    if (!typeParam.findFirstToken(58).getText().equals(tag.getArg1().substring(1, tag.getArg1().length() - 1))) continue;
                    found = true;
                    typeParamsIt.remove();
                    break;
                }
            }
            if (found) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, "@param", tag.getArg1());
        }
        if (!this.allowMissingParamTags && reportExpectedTags) {
            for (DetailAST param : params) {
                this.log(param, MSG_EXCPECTED_TAG, JavadocTagInfo.PARAM.getText(), param.getText());
            }
            for (DetailAST typeParam : typeParams) {
                this.log(typeParam, MSG_EXCPECTED_TAG, JavadocTagInfo.PARAM.getText(), "<" + typeParam.findFirstToken(58).getText() + ">");
            }
        }
    }

    private boolean isFunction(DetailAST ast) {
        DetailAST typeAST;
        boolean retVal = false;
        if (ast.getType() == 9 && (typeAST = ast.findFirstToken(13)) != null && typeAST.findFirstToken(49) == null) {
            retVal = true;
        }
        return retVal;
    }

    private void checkReturnTag(List<JavadocTag> tags, int lineNo, boolean reportExpectedTags) {
        boolean found = false;
        ListIterator<JavadocTag> it = tags.listIterator();
        while (it.hasNext()) {
            JavadocTag jt = it.next();
            if (!jt.isReturnTag()) continue;
            if (found) {
                this.log(jt.getLineNo(), jt.getColumnNo(), MSG_DUPLICATE_TAG, JavadocTagInfo.RETURN.getText());
            }
            found = true;
            it.remove();
        }
        if (!found && !this.allowMissingReturnTag && reportExpectedTags) {
            this.log(lineNo, MSG_RETURN_EXPECTED, new Object[0]);
        }
    }

    private void checkThrowsTags(List<JavadocTag> tags, List<ExceptionInfo> throwsList, boolean reportExpectedTags) {
        HashSet foundThrows = Sets.newHashSet();
        ListIterator<JavadocTag> tagIt = tags.listIterator();
        while (tagIt.hasNext()) {
            ExceptionInfo ei;
            JavadocTag tag = tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            String documentedEx = tag.getArg1();
            AbstractTypeAwareCheck.Token token = new AbstractTypeAwareCheck.Token(tag.getArg1(), tag.getLineNo(), tag.getColumnNo());
            AbstractTypeAwareCheck.ClassInfo documentedCI = this.createClassInfo(token, this.getCurrentClassName());
            boolean found = foundThrows.contains(documentedEx);
            ListIterator<ExceptionInfo> throwIt = throwsList.listIterator();
            while (!found && throwIt.hasNext()) {
                ei = throwIt.next();
                if (!ei.getName().getText().equals(documentedCI.getName().getText())) continue;
                found = true;
                ei.setFound();
                foundThrows.add(documentedEx);
            }
            throwIt = throwsList.listIterator();
            while (!found && throwIt.hasNext()) {
                ei = throwIt.next();
                if (documentedCI.getClazz() == ei.getClazz()) {
                    found = true;
                    ei.setFound();
                    foundThrows.add(documentedEx);
                    continue;
                }
                if (!this.allowThrowsTagsForSubclasses) continue;
                found = this.isSubclass(documentedCI.getClazz(), ei.getClazz());
            }
            if (found) continue;
            boolean reqd = true;
            if (this.allowUndeclaredRTE) {
                boolean bl = reqd = !this.isUnchecked(documentedCI.getClazz());
            }
            if (!reqd || !this.validateThrows) continue;
            this.log(tag.getLineNo(), tag.getColumnNo(), MSG_UNUSED_TAG, JavadocTagInfo.THROWS.getText(), tag.getArg1());
        }
        if (!this.allowMissingThrowsTags && reportExpectedTags) {
            for (ExceptionInfo ei : throwsList) {
                if (ei.isFound()) continue;
                AbstractTypeAwareCheck.Token fi = ei.getName();
                this.log(fi.getLineNo(), fi.getColumnNo(), MSG_EXCPECTED_TAG, JavadocTagInfo.THROWS.getText(), fi.getText());
            }
        }
    }

    private boolean isSetterMethod(DetailAST ast) {
        if (ast.getType() != 9 || ast.getChildCount() != 7) {
            return false;
        }
        DetailAST type = ast.findFirstToken(13);
        String name = type.getNextSibling().getText();
        if (!name.matches("^set[A-Z].*")) {
            return false;
        }
        if (type.getChildCount(49) == 0) {
            return false;
        }
        DetailAST params = ast.findFirstToken(20);
        if (params == null || params.getChildCount(21) != 1) {
            return false;
        }
        DetailAST slist = ast.findFirstToken(7);
        if (slist == null || slist.getChildCount() != 3) {
            return false;
        }
        DetailAST expr = slist.getFirstChild();
        return expr.getType() == 28 && expr.getFirstChild().getType() == 80;
    }

    private boolean isGetterMethod(DetailAST ast) {
        if (ast.getType() != 9 || ast.getChildCount() != 7) {
            return false;
        }
        DetailAST type = ast.findFirstToken(13);
        String name = type.getNextSibling().getText();
        if (!name.matches("^(is|get)[A-Z].*")) {
            return false;
        }
        if (type.getChildCount(49) > 0) {
            return false;
        }
        DetailAST params = ast.findFirstToken(20);
        if (params == null || params.getChildCount(21) > 0) {
            return false;
        }
        DetailAST slist = ast.findFirstToken(7);
        if (slist == null || slist.getChildCount() != 2) {
            return false;
        }
        DetailAST expr = slist.getFirstChild();
        return expr.getType() == 88 && expr.getFirstChild().getType() == 28;
    }

    private static class ExceptionInfo {
        private boolean found;
        private final AbstractTypeAwareCheck.ClassInfo classInfo;

        ExceptionInfo(AbstractTypeAwareCheck.ClassInfo classInfo) {
            this.classInfo = classInfo;
        }

        final void setFound() {
            this.found = true;
        }

        final boolean isFound() {
            return this.found;
        }

        final AbstractTypeAwareCheck.Token getName() {
            return this.classInfo.getName();
        }

        final Class<?> getClazz() {
            return this.classInfo.getClazz();
        }
    }
}

